# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import BaseModel, Field, conlist, constr, validator
from lusid_workflow.models.create_child_task_configuration import CreateChildTaskConfiguration

class CreateChildTasksAction(BaseModel):
    """
    Defines a Create Child Tasks Action  # noqa: E501
    """
    type: constr(strict=True, min_length=1) = Field(..., description="Type name for this Action")
    child_task_configurations: conlist(CreateChildTaskConfiguration) = Field(..., alias="childTaskConfigurations", description="The Child Task Configurations")
    __properties = ["type", "childTaskConfigurations"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if not value == 'CreateChildTasks':
            raise ValueError("must be one of enum values ('CreateChildTasks')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateChildTasksAction:
        """Create an instance of CreateChildTasksAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in child_task_configurations (list)
        _items = []
        if self.child_task_configurations:
            for _item in self.child_task_configurations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['childTaskConfigurations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateChildTasksAction:
        """Create an instance of CreateChildTasksAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateChildTasksAction.parse_obj(obj)

        _obj = CreateChildTasksAction.parse_obj({
            "type": obj.get("type"),
            "child_task_configurations": [CreateChildTaskConfiguration.from_dict(_item) for _item in obj.get("childTaskConfigurations")] if obj.get("childTaskConfigurations") is not None else None
        })
        return _obj
