# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, ValidationError, validator
from lusid_workflow.models.create_child_tasks_action_response import CreateChildTasksActionResponse
from lusid_workflow.models.run_worker_action_response import RunWorkerActionResponse
from lusid_workflow.models.trigger_parent_task_action_response import TriggerParentTaskActionResponse
from typing import Union, Any, List, TYPE_CHECKING
from pydantic.v1 import StrictStr, Field

ACTIONDETAILSRESPONSE_ONE_OF_SCHEMAS = ["CreateChildTasksActionResponse", "RunWorkerActionResponse", "TriggerParentTaskActionResponse"]

class ActionDetailsResponse(BaseModel):
    """
    Abstracts the kinds of Actions available in a read-only form
    """
    # data type: CreateChildTasksActionResponse
    oneof_schema_1_validator: Optional[CreateChildTasksActionResponse] = None
    # data type: RunWorkerActionResponse
    oneof_schema_2_validator: Optional[RunWorkerActionResponse] = None
    # data type: TriggerParentTaskActionResponse
    oneof_schema_3_validator: Optional[TriggerParentTaskActionResponse] = None
    if TYPE_CHECKING:
        actual_instance: Union[CreateChildTasksActionResponse, RunWorkerActionResponse, TriggerParentTaskActionResponse]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(ACTIONDETAILSRESPONSE_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ActionDetailsResponse.construct()
        error_messages = []
        match = 0
        # validate data type: CreateChildTasksActionResponse
        if not isinstance(v, CreateChildTasksActionResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CreateChildTasksActionResponse`")
        else:
            match += 1
        # validate data type: RunWorkerActionResponse
        if not isinstance(v, RunWorkerActionResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunWorkerActionResponse`")
        else:
            match += 1
        # validate data type: TriggerParentTaskActionResponse
        if not isinstance(v, TriggerParentTaskActionResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TriggerParentTaskActionResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ActionDetailsResponse with oneOf schemas: CreateChildTasksActionResponse, RunWorkerActionResponse, TriggerParentTaskActionResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ActionDetailsResponse with oneOf schemas: CreateChildTasksActionResponse, RunWorkerActionResponse, TriggerParentTaskActionResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> ActionDetailsResponse:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> ActionDetailsResponse:
        """Returns the object represented by the json string"""
        instance = ActionDetailsResponse.construct()
        error_messages = []
        match = 0

        # deserialize data into CreateChildTasksActionResponse
        try:
            instance.actual_instance = CreateChildTasksActionResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RunWorkerActionResponse
        try:
            instance.actual_instance = RunWorkerActionResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TriggerParentTaskActionResponse
        try:
            instance.actual_instance = TriggerParentTaskActionResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ActionDetailsResponse with oneOf schemas: CreateChildTasksActionResponse, RunWorkerActionResponse, TriggerParentTaskActionResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ActionDetailsResponse with oneOf schemas: CreateChildTasksActionResponse, RunWorkerActionResponse, TriggerParentTaskActionResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
