from esu.base import BaseAPI


class Manager(BaseAPI):
    """
    Args:
        token (str): Токен для доступа к API. Если не передан, будет
                     использована переменная окружения **ESU_API_TOKEN**
    """
    class Meta:
        pass

    def get_all_clients(self):
        """
        Возвращает список объектов всех доступных пользователю клиентов. Если
        текущему пользователю был предоставлен доступ к еще одному клиенту,
        данный список будет содержать два элемента.

        Returns:
            list: Список объектов :class:`esu.Client`
        """
        return self._get_list('v1/client', 'esu.Client')

    def get_all_projects(self):
        """
        Возвращает список объектов всех доступных пользователю проектов. Если
        текущий пользователь имеет несколько проектов или ему предоставили
        доступ к стороннему проекту, данный список будет содержать их все.

        Returns:
            list: Список объектов :class:`esu.Project`
        """
        return self._get_list('v1/project', 'esu.Project')

    def get_all_vdcs(self):
        """
        Возвращает список объектов всех доступных пользователю ВЦОДов. Если
        текущий пользователь имеет несколько ВЦОДов или ему был предоставлен
        доступ к сотронним проектам, данный список будет содержать их все.

        Returns:
            list: Список объектов :class:`esu.Vdc`
        """
        return self._get_list('v1/vdc', 'esu.Vdc')

    def get_all_vms(self):
        """
        Возвращает список объектов всех доступных пользователю виртуальных
        выделенных серверов. Если текущий пользователь имеет несколько
        виртуальных серверов или ему был предоставлен доступ к
        сторонним проектам, данный список будет содержать их все.

        Returns:
            list: Список объектов :class:`esu.Vm`
        """
        return self._get_list('v1/vm', 'esu.Vm')
