from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import (
    define as _attrs_define,
    field as _attrs_field,
)

from ..client_types import UNSET, Unset

T = TypeVar("T", bound="WebhookLogsExport")


@_attrs_define
class WebhookLogsExport:
    """Webhook log export result containing downloadable data for debugging and monitoring webhook delivery

    Example:
        {'url': 'https://katana-exports.s3.amazonaws.com/webhook-logs-2024-01-15.csv?expires=1705392000'}

    Attributes:
        url (Union[Unset, str]): Pre-signed download URL for the webhook logs export file (CSV or JSON format)
    """

    url: Unset | str = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        url = self.url

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if url is not UNSET:
            field_dict["url"] = url

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        url = d.pop("url", UNSET)

        webhook_logs_export = cls(
            url=url,
        )

        webhook_logs_export.additional_properties = d
        return webhook_logs_export

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
