from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, cast

from attrs import define as _attrs_define

from ..client_types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.update_material_request_configs_item import (
        UpdateMaterialRequestConfigsItem,
    )


T = TypeVar("T", bound="UpdateMaterialRequest")


@_attrs_define
class UpdateMaterialRequest:
    """Request payload for updating an existing raw material's properties and specifications

    Example:
        {'name': 'Stainless Steel Sheet 304 - Updated', 'uom': 'm²', 'category_name': 'Premium Raw Materials',
            'default_supplier_id': 1502, 'additional_info': 'Food-grade stainless steel, 1.5mm thickness - Updated
            specifications', 'batch_tracked': True, 'is_sellable': False, 'is_archived': False, 'purchase_uom': 'sheet',
            'purchase_uom_conversion_rate': 2.0, 'configs': [{'id': 101, 'name': 'Grade', 'values': ['304', '316', '430']},
            {'name': 'Finish', 'values': ['Brushed', 'Mirror', 'Matte']}], 'custom_field_collection_id': 201}

    Attributes:
        name (Union[Unset, str]): Display name for the material used in inventory and manufacturing
        uom (Union[Unset, str]): Unit of measure for inventory tracking (e.g., kg, lb, pcs)
        category_name (Union[Unset, str]): Material category for organization and classification
        default_supplier_id (Union[Unset, int]): Primary supplier for purchasing this material
        additional_info (Union[Unset, str]): Additional specifications or notes about the material
        batch_tracked (Union[Unset, bool]): Whether this material uses batch tracking for quality control
        is_sellable (Union[Unset, bool]): Whether this material can be sold directly to customers
        is_archived (Union[Unset, bool]): Whether this material is archived and hidden from active use
        purchase_uom (Union[Unset, str]): If you are purchasing in a different unit of measure than the default unit of
            measure (used for tracking stock)
            for this item, you can define the purchase unit. Value null indicates that purchasing is done in same unit
            of measure. If value is not null, purchase_uom_conversion_rate must also be populated.
        purchase_uom_conversion_rate (Union[Unset, float]): The conversion rate between the purchase and material UoMs.
            If used, material must have a purchase_uom
            that is different from uom.
        configs (Union[Unset, list['UpdateMaterialRequestConfigsItem']]): When updating configs, all configs and values
            must be provided. Existing ones are matched,
                    new ones are created, and configs not provided in the update are deleted.
        custom_field_collection_id (Union[None, Unset, int]): Reference to custom field collection for additional
            material data
    """

    name: Unset | str = UNSET
    uom: Unset | str = UNSET
    category_name: Unset | str = UNSET
    default_supplier_id: Unset | int = UNSET
    additional_info: Unset | str = UNSET
    batch_tracked: Unset | bool = UNSET
    is_sellable: Unset | bool = UNSET
    is_archived: Unset | bool = UNSET
    purchase_uom: Unset | str = UNSET
    purchase_uom_conversion_rate: Unset | float = UNSET
    configs: Unset | list["UpdateMaterialRequestConfigsItem"] = UNSET
    custom_field_collection_id: None | Unset | int = UNSET

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        uom = self.uom

        category_name = self.category_name

        default_supplier_id = self.default_supplier_id

        additional_info = self.additional_info

        batch_tracked = self.batch_tracked

        is_sellable = self.is_sellable

        is_archived = self.is_archived

        purchase_uom = self.purchase_uom

        purchase_uom_conversion_rate = self.purchase_uom_conversion_rate

        configs: Unset | list[dict[str, Any]] = UNSET
        if not isinstance(self.configs, Unset):
            configs = []
            for configs_item_data in self.configs:
                configs_item = configs_item_data.to_dict()
                configs.append(configs_item)

        custom_field_collection_id: None | Unset | int
        if isinstance(self.custom_field_collection_id, Unset):
            custom_field_collection_id = UNSET
        else:
            custom_field_collection_id = self.custom_field_collection_id

        field_dict: dict[str, Any] = {}

        field_dict.update({})
        if name is not UNSET:
            field_dict["name"] = name
        if uom is not UNSET:
            field_dict["uom"] = uom
        if category_name is not UNSET:
            field_dict["category_name"] = category_name
        if default_supplier_id is not UNSET:
            field_dict["default_supplier_id"] = default_supplier_id
        if additional_info is not UNSET:
            field_dict["additional_info"] = additional_info
        if batch_tracked is not UNSET:
            field_dict["batch_tracked"] = batch_tracked
        if is_sellable is not UNSET:
            field_dict["is_sellable"] = is_sellable
        if is_archived is not UNSET:
            field_dict["is_archived"] = is_archived
        if purchase_uom is not UNSET:
            field_dict["purchase_uom"] = purchase_uom
        if purchase_uom_conversion_rate is not UNSET:
            field_dict["purchase_uom_conversion_rate"] = purchase_uom_conversion_rate
        if configs is not UNSET:
            field_dict["configs"] = configs
        if custom_field_collection_id is not UNSET:
            field_dict["custom_field_collection_id"] = custom_field_collection_id

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.update_material_request_configs_item import (
            UpdateMaterialRequestConfigsItem,
        )

        d = dict(src_dict)
        name = d.pop("name", UNSET)

        uom = d.pop("uom", UNSET)

        category_name = d.pop("category_name", UNSET)

        default_supplier_id = d.pop("default_supplier_id", UNSET)

        additional_info = d.pop("additional_info", UNSET)

        batch_tracked = d.pop("batch_tracked", UNSET)

        is_sellable = d.pop("is_sellable", UNSET)

        is_archived = d.pop("is_archived", UNSET)

        purchase_uom = d.pop("purchase_uom", UNSET)

        purchase_uom_conversion_rate = d.pop("purchase_uom_conversion_rate", UNSET)

        configs = []
        _configs = d.pop("configs", UNSET)
        for configs_item_data in _configs or []:
            configs_item = UpdateMaterialRequestConfigsItem.from_dict(configs_item_data)

            configs.append(configs_item)

        def _parse_custom_field_collection_id(data: object) -> None | Unset | int:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(None | Unset | int, data)

        custom_field_collection_id = _parse_custom_field_collection_id(
            d.pop("custom_field_collection_id", UNSET)
        )

        update_material_request = cls(
            name=name,
            uom=uom,
            category_name=category_name,
            default_supplier_id=default_supplier_id,
            additional_info=additional_info,
            batch_tracked=batch_tracked,
            is_sellable=is_sellable,
            is_archived=is_archived,
            purchase_uom=purchase_uom,
            purchase_uom_conversion_rate=purchase_uom_conversion_rate,
            configs=configs,
            custom_field_collection_id=custom_field_collection_id,
        )

        return update_material_request
