import datetime
from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import (
    define as _attrs_define,
    field as _attrs_field,
)
from dateutil.parser import isoparse

from ..client_types import UNSET, Unset

T = TypeVar("T", bound="UpdateManufacturingOrderProductionIngredientRequest")


@_attrs_define
class UpdateManufacturingOrderProductionIngredientRequest:
    """Request payload for updating ingredient consumption data in a manufacturing order production batch

    Example:
        {'quantity': 3.2, 'production_date': '2023-10-15T11:15:00Z', 'cost': 15.75}

    Attributes:
        quantity (Union[Unset, float]): Updated actual quantity of ingredient consumed
        production_date (Union[Unset, datetime.datetime]): Updated date when the ingredient was consumed in production
        cost (Union[Unset, float]): Updated cost of the ingredient consumed
    """

    quantity: Unset | float = UNSET
    production_date: Unset | datetime.datetime = UNSET
    cost: Unset | float = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        quantity = self.quantity

        production_date: Unset | str = UNSET
        if not isinstance(self.production_date, Unset):
            production_date = self.production_date.isoformat()

        cost = self.cost

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if quantity is not UNSET:
            field_dict["quantity"] = quantity
        if production_date is not UNSET:
            field_dict["production_date"] = production_date
        if cost is not UNSET:
            field_dict["cost"] = cost

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        quantity = d.pop("quantity", UNSET)

        _production_date = d.pop("production_date", UNSET)
        production_date: Unset | datetime.datetime
        if isinstance(_production_date, Unset):
            production_date = UNSET
        else:
            production_date = isoparse(_production_date)

        cost = d.pop("cost", UNSET)

        update_manufacturing_order_production_ingredient_request = cls(
            quantity=quantity,
            production_date=production_date,
            cost=cost,
        )

        update_manufacturing_order_production_ingredient_request.additional_properties = d
        return update_manufacturing_order_production_ingredient_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
