from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import (
    define as _attrs_define,
    field as _attrs_field,
)

from ..client_types import UNSET, Unset

T = TypeVar("T", bound="ProductOperationRerank")


@_attrs_define
class ProductOperationRerank:
    """Response confirming the success of a product operation reordering request

    Example:
        {'message': 'Product operation successfully reordered', 'success': True}

    Attributes:
        message (Union[Unset, str]): Status message about the reordering operation
        success (Union[Unset, bool]): Whether the reordering operation was successful
    """

    message: Unset | str = UNSET
    success: Unset | bool = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        message = self.message

        success = self.success

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if message is not UNSET:
            field_dict["message"] = message
        if success is not UNSET:
            field_dict["success"] = success

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        message = d.pop("message", UNSET)

        success = d.pop("success", UNSET)

        product_operation_rerank = cls(
            message=message,
            success=success,
        )

        product_operation_rerank.additional_properties = d
        return product_operation_rerank

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
