from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import (
    define as _attrs_define,
    field as _attrs_field,
)

from ..client_types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.outsourced_purchase_order_recipe_row import (
        OutsourcedPurchaseOrderRecipeRow,
    )


T = TypeVar("T", bound="OutsourcedPurchaseOrderRecipeRowListResponse")


@_attrs_define
class OutsourcedPurchaseOrderRecipeRowListResponse:
    """Response containing a list of outsourced purchase order recipe rows for externally manufactured products

    Example:
        {'data': [{'id': 6001, 'purchase_order_id': 1001, 'variant_id': 2002, 'planned_quantity_per_unit': 2.5,
            'ingredient_availability': 'AVAILABLE', 'ingredient_expected_date': '2023-10-15T08:00:00Z', 'notes': 'Supplier
            will handle assembly'}]}

    Attributes:
        data (Union[Unset, list['OutsourcedPurchaseOrderRecipeRow']]): List of outsourced purchase order recipe row
            records
    """

    data: Unset | list["OutsourcedPurchaseOrderRecipeRow"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        data: Unset | list[dict[str, Any]] = UNSET
        if not isinstance(self.data, Unset):
            data = []
            for data_item_data in self.data:
                data_item = data_item_data.to_dict()
                data.append(data_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if data is not UNSET:
            field_dict["data"] = data

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.outsourced_purchase_order_recipe_row import (
            OutsourcedPurchaseOrderRecipeRow,
        )

        d = dict(src_dict)
        data = []
        _data = d.pop("data", UNSET)
        for data_item_data in _data or []:
            data_item = OutsourcedPurchaseOrderRecipeRow.from_dict(data_item_data)

            data.append(data_item)

        outsourced_purchase_order_recipe_row_list_response = cls(
            data=data,
        )

        outsourced_purchase_order_recipe_row_list_response.additional_properties = d
        return outsourced_purchase_order_recipe_row_list_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
