from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import (
    define as _attrs_define,
    field as _attrs_field,
)

if TYPE_CHECKING:
    from ..models.inventory_movement import InventoryMovement


T = TypeVar("T", bound="InventoryMovementListResponse")


@_attrs_define
class InventoryMovementListResponse:
    """A list of inventory movement records tracking stock changes, transfers, and adjustments across locations.

    Example:
        {'data': [{'id': 5001, 'variant_id': 2002, 'location_id': 1, 'movement_type': 'TRANSFER_IN', 'quantity': 10.0,
            'cost_per_unit': 12.5, 'total_cost': 125.0, 'reference_id': 1001, 'movement_date': '2023-10-15T14:30:00Z',
            'notes': 'Received from supplier shipment'}]}

    Attributes:
        data (list['InventoryMovement']): Array of inventory movement records with transaction details
    """

    data: list["InventoryMovement"]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        data = []
        for data_item_data in self.data:
            data_item = data_item_data.to_dict()
            data.append(data_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "data": data,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.inventory_movement import InventoryMovement

        d = dict(src_dict)
        data = []
        _data = d.pop("data")
        for data_item_data in _data:
            data_item = InventoryMovement.from_dict(data_item_data)

            data.append(data_item)

        inventory_movement_list_response = cls(
            data=data,
        )

        inventory_movement_list_response.additional_properties = d
        return inventory_movement_list_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
