from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define

from ..client_types import UNSET, Unset

T = TypeVar("T", bound="CreateSalesReturnRowRequest")


@_attrs_define
class CreateSalesReturnRowRequest:
    """Request payload for creating a new sales return row with product and quantity information

    Attributes:
        variant_id (int): ID of the variant being returned
        quantity (float): Quantity being returned
        return_reason_id (Union[Unset, int]): ID of the return reason
        notes (Union[Unset, str]): Optional notes about this returned item
    """

    variant_id: int
    quantity: float
    return_reason_id: Unset | int = UNSET
    notes: Unset | str = UNSET

    def to_dict(self) -> dict[str, Any]:
        variant_id = self.variant_id

        quantity = self.quantity

        return_reason_id = self.return_reason_id

        notes = self.notes

        field_dict: dict[str, Any] = {}

        field_dict.update(
            {
                "variant_id": variant_id,
                "quantity": quantity,
            }
        )
        if return_reason_id is not UNSET:
            field_dict["return_reason_id"] = return_reason_id
        if notes is not UNSET:
            field_dict["notes"] = notes

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        variant_id = d.pop("variant_id")

        quantity = d.pop("quantity")

        return_reason_id = d.pop("return_reason_id", UNSET)

        notes = d.pop("notes", UNSET)

        create_sales_return_row_request = cls(
            variant_id=variant_id,
            quantity=quantity,
            return_reason_id=return_reason_id,
            notes=notes,
        )

        return create_sales_return_row_request
