/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverPolygonEps
implements UDriver<UPolygon, EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(UPolygon shape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        HColor hColor;
        double[] points = new double[shape.getPoints().size() * 2];
        int i = 0;
        for (Point2D point2D : shape.getPoints()) {
            points[i++] = point2D.getX() + x;
            points[i++] = point2D.getY() + y;
        }
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            void var12_12;
            boolean bl = false;
            while (var12_12 < points.length) {
                if (!clip.isInside(points[var12_12], points[var12_12 + true])) {
                    return;
                }
                var12_12 += 2;
            }
        }
        if (shape.getDeltaShadow() != 0.0) {
            eps.epsPolygonShadow(shape.getDeltaShadow(), points);
        }
        if ((hColor = param.getBackcolor()) instanceof HColorGradient) {
            eps.setStrokeColor(mapper.toColor(param.getColor()));
            eps.epsPolygon((HColorGradient)hColor, mapper, points);
        } else {
            eps.setFillColor(mapper.toColor(hColor));
            eps.setStrokeColor(mapper.toColor(param.getColor()));
            eps.epsPolygon(points);
        }
    }
}

