/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;

public class SecurityUtils {
    private static SecurityProfile current = null;

    public static synchronized SecurityProfile getSecurityProfile() {
        if (current == null) {
            current = SecurityProfile.init();
        }
        return current;
    }

    public static boolean getJavascriptUnsecure() {
        String env = SecurityUtils.getenv("PLANTUML_JAVASCRIPT_UNSECURE");
        if ("true".equalsIgnoreCase(env)) {
            return true;
        }
        return OptionFlags.ALLOW_INCLUDE;
    }

    public static String getenv(String name) {
        String env = System.getProperty(name);
        if (StringUtils.isNotEmpty(env)) {
            return env;
        }
        return System.getenv(name);
    }

    public static List<SFile> getPath(String prop) {
        ArrayList<SFile> result = new ArrayList<SFile>();
        String paths = SecurityUtils.getenv(prop);
        if (paths == null) {
            return Collections.unmodifiableList(result);
        }
        paths = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(paths);
        StringTokenizer st = new StringTokenizer(paths, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            try {
                SFile f = new SFile(st.nextToken()).getCanonicalFile();
                if (!f.isDirectory()) continue;
                result.add(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean allowSvgText() {
        return true;
    }

    public static PrintWriter createPrintWriter(OutputStream os) {
        return new PrintWriter(os);
    }

    public static PrintWriter createPrintWriter(OutputStream os, boolean append) {
        return new PrintWriter(os, append);
    }

    public static PrintStream createPrintStream(OutputStream os) {
        return new PrintStream(os);
    }

    public static PrintStream createPrintStream(OutputStream os, boolean autoFlush, String charset) throws UnsupportedEncodingException {
        return new PrintStream(os, autoFlush, charset);
    }

    public static PrintStream createPrintStream(OutputStream os, boolean autoFlush, Charset charset) throws UnsupportedEncodingException {
        return new PrintStream(os, autoFlush, charset.name());
    }

    public static synchronized BufferedImage readRasterImage(ImageIcon imageIcon) {
        Image tmpImage = imageIcon.getImage();
        if (imageIcon.getIconWidth() == -1) {
            return null;
        }
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        image.getGraphics().drawImage(tmpImage, 0, 0, null);
        tmpImage.flush();
        return image;
    }

    public static FileReader createFileReader(String path) throws FileNotFoundException {
        return new FileReader(path);
    }

    public static PrintWriter createPrintWriter(String path) throws FileNotFoundException {
        return new PrintWriter(path);
    }

    public static FileOutputStream createFileOutputStream(String path) throws FileNotFoundException {
        return new FileOutputStream(path);
    }
}

