/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.Noise;

public final class TinyHashableString {
    private final String sentence;
    private int cachedTinyHash = -1;

    public TinyHashableString(String sentence) {
        this.sentence = sentence;
    }

    public final String getSentence() {
        return this.sentence;
    }

    public final synchronized int tinyHash() throws UnsupportedEncodingException {
        if (this.cachedTinyHash == -1) {
            this.cachedTinyHash = Noise.shortHash(this.sentence.getBytes(StandardCharsets.UTF_8), Dedication.N.toByteArray());
        }
        return this.cachedTinyHash;
    }
}

