/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Properties;
import java.util.StringTokenizer;
import jcckit.graphic.ClippingShape;
import jcckit.plot.Curve;
import jcckit.plot.CurveFactory;
import jcckit.plot.Legend;
import jcckit.plot.SimpleCurve;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

public class SimpleCurveFactory
implements CurveFactory {
    public static final String DEFINITIONS_KEY = "definitions";
    private ConfigParameters[] _configs = new ConfigParameters[]{new ConfigParameters(new PropertiesBasedConfigData(new Properties()))};

    public SimpleCurveFactory(ConfigParameters config) {
        String value = config.get(DEFINITIONS_KEY, null);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            this._configs = new ConfigParameters[tokenizer.countTokens()];
            for (int i = 0; i < this._configs.length; ++i) {
                this._configs[i] = config.getNode(tokenizer.nextToken());
            }
        }
    }

    @Override
    public Curve create(int curveIndex, int numberOfCurves, ClippingShape clippingShape, Legend legend) {
        return new SimpleCurve(this._configs[curveIndex % this._configs.length], curveIndex, numberOfCurves, clippingShape, legend);
    }
}

