# Polygon Comparison Tool

A diagnostic tool for comparing polygons generated by MetGenC's spatial module with reference polygons from NASA's Common Metadata Repository (CMR).

## Overview

The polygon comparison tool helps validate and analyze the quality of polygons generated from flightline point data. It provides visual comparisons, coverage metrics, and quality analysis to ensure generated polygons meet NASA CMR standards.

## Usage

```bash
# Compare 10 random granules from a collection
metgenc-lab-polygons compare LVISF2 -n 10 --provider NSIDC_CPRD

# Compare a specific granule
metgenc-lab-polygons compare LVISF2 --granule "GRANULE_NAME"

# Use custom output directory
metgenc-lab-polygons compare ILVIS2 -n 20 -o /tmp/polygon_analysis

# Validate a polygon file
metgenc-lab-polygons validate polygon.geojson --check-coverage --points-file points.csv
```

## Commands

### `compare`
Compares generated polygons with CMR reference polygons for a collection.

**Arguments:**
- `COLLECTION`: The collection short name (e.g., LVISF2, ILVIS2)

**Options:**
- `-n, --number`: Number of granules to process (default: 5)
- `-p, --provider`: Data provider (e.g., NSIDC_CPRD)
- `-o, --output`: Output directory (default: polygon_comparisons)
- `--granule`: Process specific granule instead of random selection

### `validate`
Validates polygon geometry and optionally checks data coverage.

**Arguments:**
- `POLYGON_FILE`: Path to polygon file (GeoJSON, WKT, or Shapely format)

**Options:**
- `--check-coverage`: Calculate data coverage statistics
- `--points-file`: CSV file with lon,lat columns for coverage check

## Output

The tool generates comprehensive comparison reports including:

### Visual Outputs
- Side-by-side plots comparing generated vs CMR polygons
- Overlay visualizations showing polygon differences
- Point cloud visualizations with polygon boundaries

### Metrics Reports
- **Coverage Statistics**: Percentage of data points within polygon
- **Vertex Count**: Number of vertices in each polygon
- **Area Comparison**: Relative areas of generated vs reference polygons
- **Quality Metrics**: Various geometric quality indicators

### File Outputs
- GeoJSON files of generated polygons
- CSV files with detailed metrics
- PNG/PDF visualization plots
- Summary report with processing metadata

## Architecture

The tool consists of three main components:

### 1. `polygon_driver.py`
- Orchestrates the comparison workflow
- Handles CMR queries and data retrieval
- Manages batch processing of collections

### 2. `spatial_cli.py`
- Provides the CLI interface
- Handles command parsing and validation
- Manages output directory creation

### 3. `spatial_utils.py`
- Contains utility functions for:
  - Polygon validation
  - Coverage calculations
  - Visualization generation
  - Metric computations

## Authentication

The tool uses earthaccess for authentication with NASA Earthdata:
- Set environment variables:
  - `export EARTHDATA_USERNAME=your-username`
  - `export EARTHDATA_PASSWORD=your-password`

## Use Cases

1. **Quality Assurance**: Validate that generated polygons maintain adequate data coverage
2. **Parameter Tuning**: Test different polygon generation parameters
3. **Collection Analysis**: Analyze polygon characteristics across entire collections
4. **Debugging**: Investigate specific granules with polygon generation issues

## Integration with Spatial Module

This tool works in conjunction with the spatial module's `create_flightline_polygon()` function. It uses the same polygon generation algorithm but adds comparison and analysis capabilities for validation purposes.

## Dependencies

- `earthaccess`: NASA Earthdata authentication
- `geopandas`: Spatial data manipulation
- `matplotlib`: Visualization generation
- `shapely`: Polygon geometry operations
