"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.DetailType = exports.PipelineEvent = exports.ApplicationEvent = exports.ProjectEvent = exports.RepositoryEvent = exports.ApplicationNotificationRule = exports.ProjectNotificationRule = exports.PipelineNotificationRule = exports.RepositoryNotificationRule = exports.NotificationRule = void 0;
const aws_codestarnotifications_1 = require("@aws-cdk/aws-codestarnotifications");
const core_1 = require("@aws-cdk/core");
class NotificationRule extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.targets = new Array();
        for (const target of props.targets || []) {
            this.addTarget(target);
        }
        const notificationRule = new aws_codestarnotifications_1.CfnNotificationRule(this, 'NotificationRule', {
            name: props.name,
            status: props.status || Status.ENABLED,
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: props.events,
            resource: props.resource,
        });
        this.notificationRuleArn = notificationRule.ref;
    }
    addTarget(target) {
        this.targets.push(target.bind(this, this));
    }
    validate() {
        if (this.targets.length === 0) {
            return ['Notification rule must have a target'];
        }
        return [];
    }
}
exports.NotificationRule = NotificationRule;
class RepositoryNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.repository.repositoryArn,
        });
    }
}
exports.RepositoryNotificationRule = RepositoryNotificationRule;
class PipelineNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.pipeline.pipelineArn,
        });
    }
}
exports.PipelineNotificationRule = PipelineNotificationRule;
class ProjectNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.project.projectArn,
        });
    }
}
exports.ProjectNotificationRule = ProjectNotificationRule;
class ApplicationNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.application.applicationArn,
        });
    }
}
exports.ApplicationNotificationRule = ApplicationNotificationRule;
var RepositoryEvent;
(function (RepositoryEvent) {
    RepositoryEvent["COMMENTS_ON_COMMITS"] = "codecommit-repository-comments-on-commits";
    RepositoryEvent["COMMENTS_ON_PULL_REQUEST"] = "codecommit-repository-comments-on-pull-requests";
    RepositoryEvent["APPROVAL_STATUS_CHANGED"] = "codecommit-repository-approvals-status-changed";
    RepositoryEvent["APPROVAL_RULE_OVERRIDE"] = "codecommit-repository-approvals-rule-override";
    RepositoryEvent["PULL_REQUEST_CREATED"] = "codecommit-repository-pull-request-created";
    RepositoryEvent["PULL_REQUEST_SOURCE_UPDATED"] = "codecommit-repository-pull-request-source-updated";
    RepositoryEvent["PULL_REQUEST_STATUS_CHANGED"] = "codecommit-repository-pull-request-status-changed";
    RepositoryEvent["PULL_REQUEST_MERGED"] = "codecommit-repository-pull-request-merged";
    RepositoryEvent["BRANCHES_AND_TAGS_CREATED"] = "codecommit-repository-branches-and-tags-created";
    RepositoryEvent["BRANCHES_AND_TAGS_DELETED"] = "codecommit-repository-branches-and-tags-deleted";
    RepositoryEvent["BRANCHES_AND_TAGS_UPDATED"] = "codecommit-repository-branches-and-tags-updated";
})(RepositoryEvent = exports.RepositoryEvent || (exports.RepositoryEvent = {}));
var ProjectEvent;
(function (ProjectEvent) {
    ProjectEvent["BUILD_STATE_FAILED"] = "codebuild-project-build-state-failed";
    ProjectEvent["BUILD_STATE_SUCCEEDED"] = "codebuild-project-build-state-succeeded";
    ProjectEvent["BUILD_STATE_IN_PROGRESS"] = "codebuild-project-build-state-in-progress";
    ProjectEvent["BUILD_STATE_STOPPED"] = "codebuild-project-build-state-stopped";
    ProjectEvent["BUILD_PHASE_FAILRE"] = "codebuild-project-build-phase-failure";
    ProjectEvent["BUILD_PHASE_SUCCESS"] = "codebuild-project-build-phase-success";
})(ProjectEvent = exports.ProjectEvent || (exports.ProjectEvent = {}));
var ApplicationEvent;
(function (ApplicationEvent) {
    ApplicationEvent["DEPLOYMENT_FAILED"] = "codedeploy-application-deployment-failed";
    ApplicationEvent["DEPLOYMENT_SUCCEEDED"] = "codedeploy-application-deployment-succeeded";
    ApplicationEvent["DEPLOYMENT_STARTED"] = "codedeploy-application-deployment-started";
})(ApplicationEvent = exports.ApplicationEvent || (exports.ApplicationEvent = {}));
var PipelineEvent;
(function (PipelineEvent) {
    PipelineEvent["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    PipelineEvent["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    PipelineEvent["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    PipelineEvent["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    PipelineEvent["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    PipelineEvent["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    PipelineEvent["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    PipelineEvent["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    PipelineEvent["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    PipelineEvent["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    PipelineEvent["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    PipelineEvent["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    PipelineEvent["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    PipelineEvent["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    PipelineEvent["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    PipelineEvent["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineEvent = exports.PipelineEvent || (exports.PipelineEvent = {}));
var DetailType;
(function (DetailType) {
    DetailType["FULL"] = "FULL";
    DetailType["BASIC"] = "BASIC";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
var Status;
(function (Status) {
    Status["DISABLED"] = "DISABLED";
    Status["ENABLED"] = "ENABLED";
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=data:application/json;base64,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