import { __assign, __awaiter, __generator } from "tslib";
import { HttpRequest, HttpResponse } from "@aws-sdk/protocol-http";
import { getSkewCorrectedDate } from "./utils/getSkewCorrectedDate";
import { getUpdatedSystemClockOffset } from "./utils/getUpdatedSystemClockOffset";
export var awsAuthMiddleware = function (options) {
    return function (next, context) {
        return function (args) {
            return __awaiter(this, void 0, void 0, function () {
                var signer, output, _a, _b, dateHeader;
                var _c;
                return __generator(this, function (_d) {
                    switch (_d.label) {
                        case 0:
                            if (!HttpRequest.isInstance(args.request))
                                return [2, next(args)];
                            return [4, options.signer()];
                        case 1:
                            signer = _d.sent();
                            _a = next;
                            _b = [__assign({}, args)];
                            _c = {};
                            return [4, signer.sign(args.request, {
                                    signingDate: getSkewCorrectedDate(options.systemClockOffset),
                                    signingRegion: context["signing_region"],
                                    signingService: context["signing_service"],
                                })];
                        case 2: return [4, _a.apply(void 0, [__assign.apply(void 0, _b.concat([(_c.request = _d.sent(), _c)]))]).catch(function (error) {
                                var _a;
                                var serverTime = (_a = error.ServerTime) !== null && _a !== void 0 ? _a : getDateHeader(error.$response);
                                if (serverTime) {
                                    options.systemClockOffset = getUpdatedSystemClockOffset(serverTime, options.systemClockOffset);
                                }
                                throw error;
                            })];
                        case 3:
                            output = _d.sent();
                            dateHeader = getDateHeader(output.response);
                            if (dateHeader) {
                                options.systemClockOffset = getUpdatedSystemClockOffset(dateHeader, options.systemClockOffset);
                            }
                            return [2, output];
                    }
                });
            });
        };
    };
};
var getDateHeader = function (response) { var _a, _b, _c; return HttpResponse.isInstance(response) ? (_b = (_a = response.headers) === null || _a === void 0 ? void 0 : _a.date) !== null && _b !== void 0 ? _b : (_c = response.headers) === null || _c === void 0 ? void 0 : _c.Date : undefined; };
export var awsAuthMiddlewareOptions = {
    name: "awsAuthMiddleware",
    tags: ["SIGNATURE", "AWSAUTH"],
    relation: "after",
    toMiddleware: "retryMiddleware",
    override: true,
};
export var getAwsAuthPlugin = function (options) { return ({
    applyToStack: function (clientStack) {
        clientStack.addRelativeTo(awsAuthMiddleware(options), awsAuthMiddlewareOptions);
    },
}); };
export var getSigV4AuthPlugin = getAwsAuthPlugin;
