import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { DeleteSecretRequest, DeleteSecretResponse } from "../models/models_0";
import { SecretsManagerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../SecretsManagerClient";
export interface DeleteSecretCommandInput extends DeleteSecretRequest {
}
export interface DeleteSecretCommandOutput extends DeleteSecretResponse, __MetadataBearer {
}

export declare class DeleteSecretCommand extends $Command<DeleteSecretCommandInput, DeleteSecretCommandOutput, SecretsManagerClientResolvedConfig> {
    readonly input: DeleteSecretCommandInput;
    constructor(input: DeleteSecretCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SecretsManagerClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteSecretCommandInput, DeleteSecretCommandOutput>;
    private serialize;
    private deserialize;
}
