import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSecretRequest, CreateSecretResponse } from "../models/models_0";
import { deserializeAws_json1_1CreateSecretCommand, serializeAws_json1_1CreateSecretCommand, } from "../protocols/Aws_json1_1";
var CreateSecretCommand = (function (_super) {
    __extends(CreateSecretCommand, _super);
    function CreateSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "CreateSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSecretRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSecretResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1CreateSecretCommand(input, context);
    };
    CreateSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1CreateSecretCommand(output, context);
    };
    return CreateSecretCommand;
}($Command));
export { CreateSecretCommand };
