"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_environment_secrets_1 = require("../handler/secrets/action-environment-secrets");
class ActionEnvironmentSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret, environment } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const handler = new action_environment_secrets_1.ActionEnvironmentSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionEnvironmentSecretCustomResourceHandler',
            description: 'Handles the creation/deletion of a GitHub Action environment secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            environment,
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionEnvironmentSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionEnvironmentSecret = ActionEnvironmentSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionEnvironmentSecret[_a] = { fqn: "cdk-github.ActionEnvironmentSecret", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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