# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.deploy_v1 import gapic_version as package_version

__version__ = package_version.__version__


from .services.cloud_deploy import CloudDeployAsyncClient, CloudDeployClient
from .types.automation_payload import AutomationEvent
from .types.automationrun_payload import AutomationRunEvent
from .types.cloud_deploy import (
    AbandonReleaseRequest,
    AbandonReleaseResponse,
    AdvanceChildRolloutJob,
    AdvanceChildRolloutJobRun,
    AdvanceRolloutOperation,
    AdvanceRolloutRequest,
    AdvanceRolloutResponse,
    AdvanceRolloutRule,
    AnthosCluster,
    ApproveRolloutRequest,
    ApproveRolloutResponse,
    AssociatedEntities,
    Automation,
    AutomationResourceSelector,
    AutomationRolloutMetadata,
    AutomationRule,
    AutomationRuleCondition,
    AutomationRun,
    BackoffMode,
    BuildArtifact,
    Canary,
    CanaryDeployment,
    CancelAutomationRunRequest,
    CancelAutomationRunResponse,
    CancelRolloutRequest,
    CancelRolloutResponse,
    ChildRolloutJobs,
    CloudRunConfig,
    CloudRunLocation,
    CloudRunMetadata,
    CloudRunRenderMetadata,
    Config,
    CreateAutomationRequest,
    CreateChildRolloutJob,
    CreateChildRolloutJobRun,
    CreateCustomTargetTypeRequest,
    CreateDeliveryPipelineRequest,
    CreateDeployPolicyRequest,
    CreateReleaseRequest,
    CreateRolloutRequest,
    CreateTargetRequest,
    CustomCanaryDeployment,
    CustomMetadata,
    CustomTarget,
    CustomTargetDeployMetadata,
    CustomTargetSkaffoldActions,
    CustomTargetType,
    DefaultPool,
    DeleteAutomationRequest,
    DeleteCustomTargetTypeRequest,
    DeleteDeliveryPipelineRequest,
    DeleteDeployPolicyRequest,
    DeleteTargetRequest,
    DeliveryPipeline,
    DeliveryPipelineAttribute,
    DeployArtifact,
    DeployJob,
    DeployJobRun,
    DeployJobRunMetadata,
    DeploymentJobs,
    DeployParameters,
    DeployPolicy,
    DeployPolicyResourceSelector,
    ExecutionConfig,
    GetAutomationRequest,
    GetAutomationRunRequest,
    GetConfigRequest,
    GetCustomTargetTypeRequest,
    GetDeliveryPipelineRequest,
    GetDeployPolicyRequest,
    GetJobRunRequest,
    GetReleaseRequest,
    GetRolloutRequest,
    GetTargetRequest,
    GkeCluster,
    IgnoreJobRequest,
    IgnoreJobResponse,
    Job,
    JobRun,
    KubernetesConfig,
    ListAutomationRunsRequest,
    ListAutomationRunsResponse,
    ListAutomationsRequest,
    ListAutomationsResponse,
    ListCustomTargetTypesRequest,
    ListCustomTargetTypesResponse,
    ListDeliveryPipelinesRequest,
    ListDeliveryPipelinesResponse,
    ListDeployPoliciesRequest,
    ListDeployPoliciesResponse,
    ListJobRunsRequest,
    ListJobRunsResponse,
    ListReleasesRequest,
    ListReleasesResponse,
    ListRolloutsRequest,
    ListRolloutsResponse,
    ListTargetsRequest,
    ListTargetsResponse,
    Metadata,
    MultiTarget,
    OneTimeWindow,
    OperationMetadata,
    Phase,
    PipelineCondition,
    PipelineReadyCondition,
    PolicyRule,
    PolicyViolation,
    PolicyViolationDetails,
    Postdeploy,
    PostdeployJob,
    PostdeployJobRun,
    Predeploy,
    PredeployJob,
    PredeployJobRun,
    PrivatePool,
    PromoteReleaseOperation,
    PromoteReleaseRule,
    Release,
    RenderMetadata,
    RepairPhase,
    RepairPhaseConfig,
    RepairRolloutOperation,
    RepairRolloutRule,
    RepairState,
    Retry,
    RetryAttempt,
    RetryJobRequest,
    RetryJobResponse,
    RetryPhase,
    Rollback,
    RollbackAttempt,
    RollbackTargetConfig,
    RollbackTargetRequest,
    RollbackTargetResponse,
    Rollout,
    RolloutRestriction,
    RuntimeConfig,
    SerialPipeline,
    SkaffoldModules,
    SkaffoldSupportState,
    SkaffoldVersion,
    Stage,
    Standard,
    Strategy,
    Target,
    TargetArtifact,
    TargetAttribute,
    TargetsPresentCondition,
    TargetsTypeCondition,
    TerminateJobRunRequest,
    TerminateJobRunResponse,
    TimedPromoteReleaseCondition,
    TimedPromoteReleaseOperation,
    TimedPromoteReleaseRule,
    TimeWindows,
    UpdateAutomationRequest,
    UpdateCustomTargetTypeRequest,
    UpdateDeliveryPipelineRequest,
    UpdateDeployPolicyRequest,
    UpdateTargetRequest,
    VerifyJob,
    VerifyJobRun,
    WeeklyWindow,
)
from .types.customtargettype_notification_payload import (
    CustomTargetTypeNotificationEvent,
)
from .types.deliverypipeline_notification_payload import (
    DeliveryPipelineNotificationEvent,
)
from .types.deploypolicy_evaluation_payload import DeployPolicyEvaluationEvent
from .types.deploypolicy_notification_payload import DeployPolicyNotificationEvent
from .types.jobrun_notification_payload import JobRunNotificationEvent
from .types.log_enums import Type
from .types.release_notification_payload import ReleaseNotificationEvent
from .types.release_render_payload import ReleaseRenderEvent
from .types.rollout_notification_payload import RolloutNotificationEvent
from .types.rollout_update_payload import RolloutUpdateEvent
from .types.target_notification_payload import TargetNotificationEvent

__all__ = (
    "CloudDeployAsyncClient",
    "AbandonReleaseRequest",
    "AbandonReleaseResponse",
    "AdvanceChildRolloutJob",
    "AdvanceChildRolloutJobRun",
    "AdvanceRolloutOperation",
    "AdvanceRolloutRequest",
    "AdvanceRolloutResponse",
    "AdvanceRolloutRule",
    "AnthosCluster",
    "ApproveRolloutRequest",
    "ApproveRolloutResponse",
    "AssociatedEntities",
    "Automation",
    "AutomationEvent",
    "AutomationResourceSelector",
    "AutomationRolloutMetadata",
    "AutomationRule",
    "AutomationRuleCondition",
    "AutomationRun",
    "AutomationRunEvent",
    "BackoffMode",
    "BuildArtifact",
    "Canary",
    "CanaryDeployment",
    "CancelAutomationRunRequest",
    "CancelAutomationRunResponse",
    "CancelRolloutRequest",
    "CancelRolloutResponse",
    "ChildRolloutJobs",
    "CloudDeployClient",
    "CloudRunConfig",
    "CloudRunLocation",
    "CloudRunMetadata",
    "CloudRunRenderMetadata",
    "Config",
    "CreateAutomationRequest",
    "CreateChildRolloutJob",
    "CreateChildRolloutJobRun",
    "CreateCustomTargetTypeRequest",
    "CreateDeliveryPipelineRequest",
    "CreateDeployPolicyRequest",
    "CreateReleaseRequest",
    "CreateRolloutRequest",
    "CreateTargetRequest",
    "CustomCanaryDeployment",
    "CustomMetadata",
    "CustomTarget",
    "CustomTargetDeployMetadata",
    "CustomTargetSkaffoldActions",
    "CustomTargetType",
    "CustomTargetTypeNotificationEvent",
    "DefaultPool",
    "DeleteAutomationRequest",
    "DeleteCustomTargetTypeRequest",
    "DeleteDeliveryPipelineRequest",
    "DeleteDeployPolicyRequest",
    "DeleteTargetRequest",
    "DeliveryPipeline",
    "DeliveryPipelineAttribute",
    "DeliveryPipelineNotificationEvent",
    "DeployArtifact",
    "DeployJob",
    "DeployJobRun",
    "DeployJobRunMetadata",
    "DeployParameters",
    "DeployPolicy",
    "DeployPolicyEvaluationEvent",
    "DeployPolicyNotificationEvent",
    "DeployPolicyResourceSelector",
    "DeploymentJobs",
    "ExecutionConfig",
    "GetAutomationRequest",
    "GetAutomationRunRequest",
    "GetConfigRequest",
    "GetCustomTargetTypeRequest",
    "GetDeliveryPipelineRequest",
    "GetDeployPolicyRequest",
    "GetJobRunRequest",
    "GetReleaseRequest",
    "GetRolloutRequest",
    "GetTargetRequest",
    "GkeCluster",
    "IgnoreJobRequest",
    "IgnoreJobResponse",
    "Job",
    "JobRun",
    "JobRunNotificationEvent",
    "KubernetesConfig",
    "ListAutomationRunsRequest",
    "ListAutomationRunsResponse",
    "ListAutomationsRequest",
    "ListAutomationsResponse",
    "ListCustomTargetTypesRequest",
    "ListCustomTargetTypesResponse",
    "ListDeliveryPipelinesRequest",
    "ListDeliveryPipelinesResponse",
    "ListDeployPoliciesRequest",
    "ListDeployPoliciesResponse",
    "ListJobRunsRequest",
    "ListJobRunsResponse",
    "ListReleasesRequest",
    "ListReleasesResponse",
    "ListRolloutsRequest",
    "ListRolloutsResponse",
    "ListTargetsRequest",
    "ListTargetsResponse",
    "Metadata",
    "MultiTarget",
    "OneTimeWindow",
    "OperationMetadata",
    "Phase",
    "PipelineCondition",
    "PipelineReadyCondition",
    "PolicyRule",
    "PolicyViolation",
    "PolicyViolationDetails",
    "Postdeploy",
    "PostdeployJob",
    "PostdeployJobRun",
    "Predeploy",
    "PredeployJob",
    "PredeployJobRun",
    "PrivatePool",
    "PromoteReleaseOperation",
    "PromoteReleaseRule",
    "Release",
    "ReleaseNotificationEvent",
    "ReleaseRenderEvent",
    "RenderMetadata",
    "RepairPhase",
    "RepairPhaseConfig",
    "RepairRolloutOperation",
    "RepairRolloutRule",
    "RepairState",
    "Retry",
    "RetryAttempt",
    "RetryJobRequest",
    "RetryJobResponse",
    "RetryPhase",
    "Rollback",
    "RollbackAttempt",
    "RollbackTargetConfig",
    "RollbackTargetRequest",
    "RollbackTargetResponse",
    "Rollout",
    "RolloutNotificationEvent",
    "RolloutRestriction",
    "RolloutUpdateEvent",
    "RuntimeConfig",
    "SerialPipeline",
    "SkaffoldModules",
    "SkaffoldSupportState",
    "SkaffoldVersion",
    "Stage",
    "Standard",
    "Strategy",
    "Target",
    "TargetArtifact",
    "TargetAttribute",
    "TargetNotificationEvent",
    "TargetsPresentCondition",
    "TargetsTypeCondition",
    "TerminateJobRunRequest",
    "TerminateJobRunResponse",
    "TimeWindows",
    "TimedPromoteReleaseCondition",
    "TimedPromoteReleaseOperation",
    "TimedPromoteReleaseRule",
    "Type",
    "UpdateAutomationRequest",
    "UpdateCustomTargetTypeRequest",
    "UpdateDeliveryPipelineRequest",
    "UpdateDeployPolicyRequest",
    "UpdateTargetRequest",
    "VerifyJob",
    "VerifyJobRun",
    "WeeklyWindow",
)
