# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.deploy import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.deploy_v1.services.cloud_deploy.async_client import (
    CloudDeployAsyncClient,
)
from google.cloud.deploy_v1.services.cloud_deploy.client import CloudDeployClient
from google.cloud.deploy_v1.types.automation_payload import AutomationEvent
from google.cloud.deploy_v1.types.automationrun_payload import AutomationRunEvent
from google.cloud.deploy_v1.types.cloud_deploy import (
    AbandonReleaseRequest,
    AbandonReleaseResponse,
    AdvanceChildRolloutJob,
    AdvanceChildRolloutJobRun,
    AdvanceRolloutOperation,
    AdvanceRolloutRequest,
    AdvanceRolloutResponse,
    AdvanceRolloutRule,
    AnthosCluster,
    ApproveRolloutRequest,
    ApproveRolloutResponse,
    AssociatedEntities,
    Automation,
    AutomationResourceSelector,
    AutomationRolloutMetadata,
    AutomationRule,
    AutomationRuleCondition,
    AutomationRun,
    BackoffMode,
    BuildArtifact,
    Canary,
    CanaryDeployment,
    CancelAutomationRunRequest,
    CancelAutomationRunResponse,
    CancelRolloutRequest,
    CancelRolloutResponse,
    ChildRolloutJobs,
    CloudRunConfig,
    CloudRunLocation,
    CloudRunMetadata,
    CloudRunRenderMetadata,
    Config,
    CreateAutomationRequest,
    CreateChildRolloutJob,
    CreateChildRolloutJobRun,
    CreateCustomTargetTypeRequest,
    CreateDeliveryPipelineRequest,
    CreateDeployPolicyRequest,
    CreateReleaseRequest,
    CreateRolloutRequest,
    CreateTargetRequest,
    CustomCanaryDeployment,
    CustomMetadata,
    CustomTarget,
    CustomTargetDeployMetadata,
    CustomTargetSkaffoldActions,
    CustomTargetType,
    DefaultPool,
    DeleteAutomationRequest,
    DeleteCustomTargetTypeRequest,
    DeleteDeliveryPipelineRequest,
    DeleteDeployPolicyRequest,
    DeleteTargetRequest,
    DeliveryPipeline,
    DeliveryPipelineAttribute,
    DeployArtifact,
    DeployJob,
    DeployJobRun,
    DeployJobRunMetadata,
    DeploymentJobs,
    DeployParameters,
    DeployPolicy,
    DeployPolicyResourceSelector,
    ExecutionConfig,
    GetAutomationRequest,
    GetAutomationRunRequest,
    GetConfigRequest,
    GetCustomTargetTypeRequest,
    GetDeliveryPipelineRequest,
    GetDeployPolicyRequest,
    GetJobRunRequest,
    GetReleaseRequest,
    GetRolloutRequest,
    GetTargetRequest,
    GkeCluster,
    IgnoreJobRequest,
    IgnoreJobResponse,
    Job,
    JobRun,
    KubernetesConfig,
    ListAutomationRunsRequest,
    ListAutomationRunsResponse,
    ListAutomationsRequest,
    ListAutomationsResponse,
    ListCustomTargetTypesRequest,
    ListCustomTargetTypesResponse,
    ListDeliveryPipelinesRequest,
    ListDeliveryPipelinesResponse,
    ListDeployPoliciesRequest,
    ListDeployPoliciesResponse,
    ListJobRunsRequest,
    ListJobRunsResponse,
    ListReleasesRequest,
    ListReleasesResponse,
    ListRolloutsRequest,
    ListRolloutsResponse,
    ListTargetsRequest,
    ListTargetsResponse,
    Metadata,
    MultiTarget,
    OneTimeWindow,
    OperationMetadata,
    Phase,
    PipelineCondition,
    PipelineReadyCondition,
    PolicyRule,
    PolicyViolation,
    PolicyViolationDetails,
    Postdeploy,
    PostdeployJob,
    PostdeployJobRun,
    Predeploy,
    PredeployJob,
    PredeployJobRun,
    PrivatePool,
    PromoteReleaseOperation,
    PromoteReleaseRule,
    Release,
    RenderMetadata,
    RepairPhase,
    RepairPhaseConfig,
    RepairRolloutOperation,
    RepairRolloutRule,
    RepairState,
    Retry,
    RetryAttempt,
    RetryJobRequest,
    RetryJobResponse,
    RetryPhase,
    Rollback,
    RollbackAttempt,
    RollbackTargetConfig,
    RollbackTargetRequest,
    RollbackTargetResponse,
    Rollout,
    RolloutRestriction,
    RuntimeConfig,
    SerialPipeline,
    SkaffoldModules,
    SkaffoldSupportState,
    SkaffoldVersion,
    Stage,
    Standard,
    Strategy,
    Target,
    TargetArtifact,
    TargetAttribute,
    TargetsPresentCondition,
    TargetsTypeCondition,
    TerminateJobRunRequest,
    TerminateJobRunResponse,
    TimedPromoteReleaseCondition,
    TimedPromoteReleaseOperation,
    TimedPromoteReleaseRule,
    TimeWindows,
    UpdateAutomationRequest,
    UpdateCustomTargetTypeRequest,
    UpdateDeliveryPipelineRequest,
    UpdateDeployPolicyRequest,
    UpdateTargetRequest,
    VerifyJob,
    VerifyJobRun,
    WeeklyWindow,
)
from google.cloud.deploy_v1.types.customtargettype_notification_payload import (
    CustomTargetTypeNotificationEvent,
)
from google.cloud.deploy_v1.types.deliverypipeline_notification_payload import (
    DeliveryPipelineNotificationEvent,
)
from google.cloud.deploy_v1.types.deploypolicy_evaluation_payload import (
    DeployPolicyEvaluationEvent,
)
from google.cloud.deploy_v1.types.deploypolicy_notification_payload import (
    DeployPolicyNotificationEvent,
)
from google.cloud.deploy_v1.types.jobrun_notification_payload import (
    JobRunNotificationEvent,
)
from google.cloud.deploy_v1.types.log_enums import Type
from google.cloud.deploy_v1.types.release_notification_payload import (
    ReleaseNotificationEvent,
)
from google.cloud.deploy_v1.types.release_render_payload import ReleaseRenderEvent
from google.cloud.deploy_v1.types.rollout_notification_payload import (
    RolloutNotificationEvent,
)
from google.cloud.deploy_v1.types.rollout_update_payload import RolloutUpdateEvent
from google.cloud.deploy_v1.types.target_notification_payload import (
    TargetNotificationEvent,
)

__all__ = (
    "CloudDeployClient",
    "CloudDeployAsyncClient",
    "AutomationEvent",
    "AutomationRunEvent",
    "AbandonReleaseRequest",
    "AbandonReleaseResponse",
    "AdvanceChildRolloutJob",
    "AdvanceChildRolloutJobRun",
    "AdvanceRolloutOperation",
    "AdvanceRolloutRequest",
    "AdvanceRolloutResponse",
    "AdvanceRolloutRule",
    "AnthosCluster",
    "ApproveRolloutRequest",
    "ApproveRolloutResponse",
    "AssociatedEntities",
    "Automation",
    "AutomationResourceSelector",
    "AutomationRolloutMetadata",
    "AutomationRule",
    "AutomationRuleCondition",
    "AutomationRun",
    "BuildArtifact",
    "Canary",
    "CanaryDeployment",
    "CancelAutomationRunRequest",
    "CancelAutomationRunResponse",
    "CancelRolloutRequest",
    "CancelRolloutResponse",
    "ChildRolloutJobs",
    "CloudRunConfig",
    "CloudRunLocation",
    "CloudRunMetadata",
    "CloudRunRenderMetadata",
    "Config",
    "CreateAutomationRequest",
    "CreateChildRolloutJob",
    "CreateChildRolloutJobRun",
    "CreateCustomTargetTypeRequest",
    "CreateDeliveryPipelineRequest",
    "CreateDeployPolicyRequest",
    "CreateReleaseRequest",
    "CreateRolloutRequest",
    "CreateTargetRequest",
    "CustomCanaryDeployment",
    "CustomMetadata",
    "CustomTarget",
    "CustomTargetDeployMetadata",
    "CustomTargetSkaffoldActions",
    "CustomTargetType",
    "DefaultPool",
    "DeleteAutomationRequest",
    "DeleteCustomTargetTypeRequest",
    "DeleteDeliveryPipelineRequest",
    "DeleteDeployPolicyRequest",
    "DeleteTargetRequest",
    "DeliveryPipeline",
    "DeliveryPipelineAttribute",
    "DeployArtifact",
    "DeployJob",
    "DeployJobRun",
    "DeployJobRunMetadata",
    "DeploymentJobs",
    "DeployParameters",
    "DeployPolicy",
    "DeployPolicyResourceSelector",
    "ExecutionConfig",
    "GetAutomationRequest",
    "GetAutomationRunRequest",
    "GetConfigRequest",
    "GetCustomTargetTypeRequest",
    "GetDeliveryPipelineRequest",
    "GetDeployPolicyRequest",
    "GetJobRunRequest",
    "GetReleaseRequest",
    "GetRolloutRequest",
    "GetTargetRequest",
    "GkeCluster",
    "IgnoreJobRequest",
    "IgnoreJobResponse",
    "Job",
    "JobRun",
    "KubernetesConfig",
    "ListAutomationRunsRequest",
    "ListAutomationRunsResponse",
    "ListAutomationsRequest",
    "ListAutomationsResponse",
    "ListCustomTargetTypesRequest",
    "ListCustomTargetTypesResponse",
    "ListDeliveryPipelinesRequest",
    "ListDeliveryPipelinesResponse",
    "ListDeployPoliciesRequest",
    "ListDeployPoliciesResponse",
    "ListJobRunsRequest",
    "ListJobRunsResponse",
    "ListReleasesRequest",
    "ListReleasesResponse",
    "ListRolloutsRequest",
    "ListRolloutsResponse",
    "ListTargetsRequest",
    "ListTargetsResponse",
    "Metadata",
    "MultiTarget",
    "OneTimeWindow",
    "OperationMetadata",
    "Phase",
    "PipelineCondition",
    "PipelineReadyCondition",
    "PolicyRule",
    "PolicyViolation",
    "PolicyViolationDetails",
    "Postdeploy",
    "PostdeployJob",
    "PostdeployJobRun",
    "Predeploy",
    "PredeployJob",
    "PredeployJobRun",
    "PrivatePool",
    "PromoteReleaseOperation",
    "PromoteReleaseRule",
    "Release",
    "RenderMetadata",
    "RepairPhase",
    "RepairPhaseConfig",
    "RepairRolloutOperation",
    "RepairRolloutRule",
    "Retry",
    "RetryAttempt",
    "RetryJobRequest",
    "RetryJobResponse",
    "RetryPhase",
    "Rollback",
    "RollbackAttempt",
    "RollbackTargetConfig",
    "RollbackTargetRequest",
    "RollbackTargetResponse",
    "Rollout",
    "RolloutRestriction",
    "RuntimeConfig",
    "SerialPipeline",
    "SkaffoldModules",
    "SkaffoldVersion",
    "Stage",
    "Standard",
    "Strategy",
    "Target",
    "TargetArtifact",
    "TargetAttribute",
    "TargetsPresentCondition",
    "TargetsTypeCondition",
    "TerminateJobRunRequest",
    "TerminateJobRunResponse",
    "TimedPromoteReleaseCondition",
    "TimedPromoteReleaseOperation",
    "TimedPromoteReleaseRule",
    "TimeWindows",
    "UpdateAutomationRequest",
    "UpdateCustomTargetTypeRequest",
    "UpdateDeliveryPipelineRequest",
    "UpdateDeployPolicyRequest",
    "UpdateTargetRequest",
    "VerifyJob",
    "VerifyJobRun",
    "WeeklyWindow",
    "BackoffMode",
    "RepairState",
    "SkaffoldSupportState",
    "CustomTargetTypeNotificationEvent",
    "DeliveryPipelineNotificationEvent",
    "DeployPolicyEvaluationEvent",
    "DeployPolicyNotificationEvent",
    "JobRunNotificationEvent",
    "Type",
    "ReleaseNotificationEvent",
    "ReleaseRenderEvent",
    "RolloutNotificationEvent",
    "RolloutUpdateEvent",
    "TargetNotificationEvent",
)
