# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sedge']

package_data = \
{'': ['*']}

install_requires = \
['click', 'requests']

entry_points = \
{'console_scripts': ['sedge = sedge.cli:cli']}

setup_kwargs = {
    'name': 'sedge',
    'version': '2.2.6',
    'description': 'Template and share OpenSSH ssh_config(5) files.',
    'long_description': "sedge\n------\n\nTemplate and share OpenSSH ssh\\_config(5) files. A preprocessor for\nOpenSSH configurations.\n\nNamed for the favourite food of the Western Ground Parrot.\nIf you find this software useful, please consider\n[donating to the effort to save](http://www.givenow.com.au/groundparrot)\nthis critically endangered species.\n\nsedge is supported on macOS, Linux/BSD, and Windows.\n\nBuild status\n------------\n\n[![Build Status](https://travis-ci.org/grahame/sedge.svg?branch=master)](https://travis-ci.org/grahame/sedge)\n\nInstallation\n------------\n\n    pip3 install sedge\n\nUsage\n-----\n    sedge\n    Usage: sedge [OPTIONS] COMMAND [ARGS]...\n\n      Template and share OpenSSH ssh_config(5) files. A preprocessor for OpenSSH\n      configurations.\n\n    Options:\n      --version                 Show the version and exit.\n      -c, --config-file TEXT\n      -o, --output-file TEXT\n      -n, --no-verify           do not verify HTTPS requests\n      -k, --key-directory TEXT  directory to scan for SSH keys\n      -v, --verbose\n      --help                    Show this message and exit.\n\n    Commands:\n      init    Initialise ~./sedge/config file if none...\n      keys    Manage ssh keys\n      update  Update ssh config from sedge specification\n\n\n\nHighlights\n-----------\n\n - Define classes of hosts, with inheritance\n - Per-site definitions describing the hosts in a site. These definitions can imported by users\n - Easily define hosts which must be accessed through one or more SSH tunnels\n - Definition variables (including numeric ranges with optional increments, and sets of values)\n - variable expansion within configuration\n - keys can be referenced by fingerprint, and a specific key used for a given host.\n   The base directory ~/.ssh is scanned for public/private key pairs, and the\n   private key with a matching fingerprint is used. No need to standardise key\n   file paths & file names when sharing configuration.\n - allowing programmatic host definitions (eg. compute0, compute1, ..., compute99)\n\nSecurity notes\n--------------\n\nUsing `@include` and shared sedge configuration files requires trust. A malicious\nsedge configuration file can be used to construct an SSH configuration file\nwhich does harmful things. Only use `@include` against trusted URLs under your\ncontrol, or under the control of someone you trust.\n\nGetting started\n---------------\n\nSedge reads `~/.sedge/config` and uses it to generate `~/.ssh/config`.\n\nBasic usage is simple:\n\n    $ sedge update\n\nNo output is generated if all goes well. Use the `-v` flag to get\nverbose output, including a diff of any changes made to your `~/.ssh/config`.\n\nBelow is an example sedge configuration file. It has the same syntax as an\nOpenSSH configuration file, but uses some additional keywords. Sedge\nkeywords begin with an '@'.\n\n    # global configuration..\n    StrictHostKeyChecking no\n\n    # variables we wish to substitute\n    @set work-username percival\n\n    # key fingerprints - sedge will find the matching private key\n    # useful when keys are shared around, and multiple people are\n    # including a sedge config - no need to standardise paths / names\n    # for the keys\n    @key work-ec2 00:0a:0b:0c:0d:0e:0f:f0:0d:01:02:02:03:04:05:06\n    @key work-storage 3e:1a:1b:0c:0d:0e:0f:f0:0d:01:02:02:03:04:05:06\n    # OpenSSH 6.8 switched over to SHA256 fingerprints; we can provide both so our\n    # sedge configs work on machines with all OpenSSH versions\n    @key work-github 8e:1a:3b:0c:0d:0e:0f:f0:0d:01:02:02:03:04:05:06 SHA256:l3mMings9/oSzgKfGWq8uZE4oB+z8lLNNid/Tv51M\n\n    # define a set of host attributes\n    @HostAttrs trusted\n        ForwardAgent yes\n\n    # ... and another\n    @HostAttrs slow-network\n        Compression yes\n        TCPKeepAlive yes\n\n    Host headnode\n        @is slow-network\n        @identity work-ec2\n        HostName headnode.example.com\n        User <work-username>\n\n    # define hosts ceph0, ceph2, .., ceph14\n    @with i {0..14/2}\n    Host ceph<i>\n        @is trusted\n        # tunnel through 'headnode'\n        @via headnode\n        @identity work-storage\n        User ceph\n\n    @with i 3 5 8\n    Host swift<i>\n        @is trusted\n        # tunnel through 'headnode'\n        @via headnode\n        @identity work-storage\n        User ceph\n\n    # pull in a public sedge definition; pass this definition an argument\n    # in the included file arguments are defined:\n    #   @args username\n    @include https://example.com/user-nodes.sedge <work-username>\n\n    # ... or we can use a file:///path\n    @include file:///path/to/my/file.sedge\n\n    # ... or we can use a path, in which case ~ will be expanded\n    @include ~/mystuff/file.sedge\n\nOther functionality\n-------------------\n\nSedge allows you to associate names with your keys. It is helpful to list\nthe keys you have, and their fingerprints, so you can give them names using\nthe `@identity`:\n\n    $ sedge list-keys\n    SHA256:lkfjFKJdslfjdfdkslFJKLKSjfdkjsdlfkSDJfksjdk  /Users/grahame/.ssh/a-key\n    SHA256:ewr12913klajslakjiejrowjeroiwjJJfisjdfjsksd  /Users/grahame/.ssh/another-key\n\nIf any of your keys do not have public keys alongside them (eg.\n`<mykey>.pub`), sedge will generate the public key file.\n\nSedge gives you a helpful shortcut to load all of your keys into `ssh-agent`:\n\n    $ sedge add-keys\n\nKeyword documentation\n---------------------\n\n`@args [arg ...]` - this keyword defines the names of variables which must\nbe passed if this file is included from another. Each `arg` will be made\navailable for substitution.\n\n`@identity <keyname>` - this keyword applies to the current Host stanza.\nIt requires that only the key `<keyname>` will be offered to log into the\nhost. This is useful if you are using a host such as github which has a\ncommon user account, and identifies you based on the key offered.\n\n`@include <url> [arg ...]` - include the sedge file at `<url>`. That file\nmay define one or more arguments with `@arg`, which should be passed\nthrough as arguments to `@include`.\n\n`@is <attr>` - this keyword applies to a Host stanza. All attributes set\nwithin the `@HostAttrs` stanza with name `<attr>` will be applied to the\ncurrent host.\n\n`@key <name> <fingerprint>` - this keyword applies globally, and the keys you\ndefine are made available to files included with `@include`. Your `~/.ssh/`\ndirectory will be scanned for keys matching `<fingerprint>`. To find the\nfingerprint for your keyfiles, run `sedge list-keys`.\n\n`@set <variable> <val>` - this keyword applies globally within the current\nfile. The `<variable>` is made available for subsitution within the file.\n\n`@via <host>` - this is a convenience keyword. It expands to a `ProxyCommand`\ndirective which allows the SSH login to bounce through `<host>`.\n\n`@with <variable> [val ..]` - this keyword applies to the next Host stanza.\nThe `<variable>` will be made available for subsitution within the stanza,\nand the stanza will be repeated for each possible value of `<variable>`.\nValues of the format `{a..b}` or `{a..b/c}` are treated specially, and are\nexpanded to the inclusive range of integers from `a` to `b` with optional\nstep `c`. If multiple `@with` keywords are applied to a Host stanza, the\nproduct of their values is used for substitution.\n\nLicense\n-------\n\nCopyright 2014-2020 [Grahame Bowland](mailto:grahame@oreamnos.com.au).\nSee the included file `LICENSE` for copying details.\n\n> This program is free software: you can redistribute it and/or modify\n> it under the terms of the GNU General Public License as published by\n> the Free Software Foundation, either version 3 of the License, or\n> (at your option) any later version.\n>\n> This program is distributed in the hope that it will be useful,\n> but WITHOUT ANY WARRANTY; without even the implied warranty of\n> MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n> GNU General Public License for more details.\n>\n> You should have received a copy of the GNU General Public License\n> along with this program.  If not, see <http://www.gnu.org/licenses/>.\n",
    'author': 'Grahame Bowland',
    'author_email': 'grahame@oreamnos.com.au',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
