/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import utility.Kit;
import utility.interfaces.ObjectIdentifiable;
import utility.sets.SetSparse;

public class SetSparsePool
extends SetSparse {
    private ObjectIdentifiable[] objects;
    private Class<? extends ObjectIdentifiable> clazz;

    public SetSparsePool(int capacity, boolean initiallyFull, Class<? extends ObjectIdentifiable> clazz) {
        super(capacity, initiallyFull);
        this.objects = new ObjectIdentifiable[capacity];
        this.clazz = clazz;
        Kit.control(clazz != null);
    }

    @Override
    public void increaseCapacity() {
        super.increaseCapacity();
        this.objects = (ObjectIdentifiable[])IntStream.range(0, this.dense.length).mapToObj(i -> i < this.objects.length ? this.objects[i] : null).toArray(ObjectIdentifiable[]::new);
    }

    public void release(int e) {
        assert (this.isPresent(e) && this.objects[e] != null) : this.sparse[e] + " " + this.limit;
        int i = this.sparse[e];
        if (i < this.limit) {
            int f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
            ObjectIdentifiable otherObject = this.objects[this.limit];
            this.objects[this.limit] = this.objects[i];
            this.objects[i] = otherObject;
        }
        --this.limit;
    }

    public ObjectIdentifiable allocate() {
        if (this.isFull()) {
            this.increaseCapacity();
        }
        ++this.limit;
        if (this.objects[this.limit] == null) {
            try {
                this.objects[this.limit] = this.clazz.newInstance();
            }
            catch (Exception e) {
                (e.getCause() == null ? e : e.getCause()).printStackTrace();
                Kit.exit("pb");
            }
            this.objects[this.limit].setId(this.limit);
        }
        assert (this.dense[this.limit] == this.objects[this.limit].getId());
        return this.objects[this.limit];
    }

    @Override
    public String toString() {
        return super.toString() + "\nsparse={" + IntStream.rangeClosed(0, this.limit).mapToObj(i -> this.objects[i] + "").collect(Collectors.joining(",")) + "}";
    }

    public static void main(String[] args) {
        SetSparsePool sp = new SetSparsePool(100, false, TestObject.class);
        for (int i = 0; i < 5; ++i) {
            sp.allocate();
            System.out.println(sp + "\n");
        }
        sp.release(2);
        System.out.println(sp + "\n");
        sp.release(1);
        System.out.println(sp + "\n");
        sp.allocate();
        System.out.println(sp + "\n");
        sp.allocate();
        System.out.println(sp + "\n");
        sp.allocate();
        System.out.println(sp + "\n");
        sp.release(2);
        System.out.println(sp + "\n");
        sp.allocate();
        System.out.println(sp + "\n");
        sp.allocate();
        System.out.println(sp + "\n");
        sp.clear();
        sp.allocate();
        sp.allocate();
        System.out.println(sp + "\n");
    }

    static class TestObject
    implements ObjectIdentifiable {
        private int id;

        TestObject() {
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int id) {
            this.id = id;
        }

        public String toString() {
            return "obj-" + this.id;
        }
    }
}

