/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.visualization;

import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import tools.remote.visualization.PointPainter;
import tools.remote.visualization.TracePainter;
import tools.remote.visualization.Tracing;

public class TracingChart
implements Tracing {
    private ITrace2D trace;
    private EMemorize memState;
    private Map<Key, ITracePoint2D> map;
    private boolean withDeletion;

    public TracingChart(ITrace2D trace, EMemorize memState) {
        this.trace = trace;
        this.memState = memState;
        if (memState == EMemorize.X_MEM || memState == EMemorize.X_Y_MEM) {
            this.map = new HashMap<Key, ITracePoint2D>();
        }
        this.withDeletion = trace.getName().contains("Deleted");
    }

    public TracingChart(ITrace2D trace) {
        this(trace, EMemorize.NO_MEM);
    }

    @Override
    public void addPoint(int x, int y, Color color) {
        if (this.memState == EMemorize.NO_MEM) {
            this.trace.addPoint((double)x, (double)y);
        } else {
            Key key = this.memState == EMemorize.X_MEM ? new Key1(x) : new Key2(x, y);
            ITracePoint2D point = this.map.get(key);
            if (point != null) {
                point.setLocation((double)x, (double)y);
            } else {
                point = new TracePoint2D((double)x, (double)y);
                if (color != null && this.withDeletion) {
                    point.addAdditionalPointPainter((IPointPainter)new PointPainter(TracePainter.EPainter.CROSS, color));
                }
                this.map.put(key, point);
                this.trace.addPoint(point);
            }
        }
    }

    @Override
    public void addPoint(int x, int y) {
        this.addPoint(x, y, null);
    }

    @Override
    public void removePoint(int x, int y) {
        if (this.memState == EMemorize.NO_MEM) {
            return;
        }
        ITracePoint2D point = this.map.remove(this.memState == EMemorize.X_MEM ? new Key1(x) : new Key2(x, y));
        if (point != null) {
            this.trace.removePoint(point);
        }
    }

    @Override
    public void clean() {
        this.trace.removeAllPoints();
        if (this.map != null) {
            this.map.clear();
        }
    }

    public class Key2
    implements Key {
        private int x;
        private int y;

        public Key2(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + TracingChart.this.hashCode();
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Key2 other = (Key2)obj;
            return this.x == other.x && this.y == other.y;
        }
    }

    private class Key1
    implements Key {
        private int x;

        public Key1(int x) {
            this.x = x;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + TracingChart.this.hashCode();
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Key1 other = (Key1)obj;
            return this.x == other.x;
        }
    }

    private static interface Key {
    }

    public static enum EMemorize {
        NO_MEM,
        X_MEM,
        X_Y_MEM;

    }
}

