/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.visualization;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import java.awt.Graphics;
import tools.remote.visualization.PointPainter;

public class TracePainter
extends ATracePainter {
    private static final int DEFAULT_SIZE = 6;
    private final APointPainter<?> pointPainter;

    public TracePainter(EPainter type, int size) {
        this.pointPainter = new PointPainter(type, size);
    }

    public TracePainter(EPainter type) {
        this(type, 6);
    }

    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        super.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
        this.pointPainter.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
    }

    public void startPaintIteration(Graphics g2d) {
        super.startPaintIteration(g2d);
        this.pointPainter.startPaintIteration(g2d);
    }

    public void endPaintIteration(Graphics g2d) {
        if (g2d != null) {
            int previousX = this.getPreviousX();
            int previousY = this.getPreviousY();
            if (previousX != Integer.MIN_VALUE || previousY != Integer.MIN_VALUE) {
                this.pointPainter.paintPoint(previousX, previousY, 0, 0, g2d, this.getPreviousPoint());
            }
        }
        this.pointPainter.endPaintIteration(g2d);
    }

    public static enum EPainter {
        PLUS,
        CROSS,
        DISC;

    }
}

