/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.visualization;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import java.awt.Color;
import java.awt.Graphics;
import tools.remote.visualization.TracePainter;

public class PointPainter
extends APointPainter<PointPainter> {
    private static final int DEFAULT_SIZE = 6;
    private TracePainter.EPainter type;
    private int size;

    public PointPainter(TracePainter.EPainter type, int size) {
        this.type = type;
        this.size = size;
    }

    public PointPainter(TracePainter.EPainter type, Color color) {
        this(type, 6);
        this.setColor(color);
    }

    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        if (this.type == TracePainter.EPainter.PLUS) {
            g.setColor(this.getColor());
            g.drawLine(absoluteX - this.size / 2, absoluteY, absoluteX + this.size / 2, absoluteY);
            g.drawLine(absoluteX, absoluteY - this.size / 2, absoluteX, absoluteY + this.size / 2);
        } else if (this.type == TracePainter.EPainter.CROSS) {
            g.setColor(this.getColor());
            g.drawLine(absoluteX - this.size / 2, absoluteY - this.size / 2, absoluteX + this.size / 2, absoluteY + this.size / 2);
            g.drawLine(absoluteX - this.size / 2, absoluteY + this.size / 2, absoluteX + this.size / 2, absoluteY - this.size / 2);
        } else {
            g.fillOval(absoluteX - this.size / 2, absoluteY - this.size / 2, this.size, this.size);
        }
    }
}

