/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import constraints.Constraint;
import executables.Resolution;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import propagation.Propagation;
import propagation.backward.BT;
import propagation.backward.PropagationBackward;
import propagation.order1.AC;
import propagation.order1.PropagationForward;
import propagation.order2.SecondOrderConsistency;
import propagation.soft.LowerBoundCapability;
import propagation.structures.revisers.Reviser;
import tools.remote.Remote;
import utility.Reflector;

public class PanelPropagation
extends JPanel {
    private static final String BACKWARD = "Backward";
    private static final String ORDER_1 = "Order 1";
    private static final String ORDER_2 = "Order 2";
    private static final String SOFT = "Soft";
    private static final String PROPAGATION = "Propagation :";
    private static final String REVISION = "Revision :";
    private static final String SUPPORT = "Support";
    private static final String APPLY = "Apply";
    private Remote remote;
    private JRadioButton backward;
    private JRadioButton order1;
    private JRadioButton order2;
    private JRadioButton soft;
    private JComboBox<String> propCombo;
    private JComboBox<String> revCombo;
    private JCheckBox support;
    private String[] backwardList = Remote.getArrayFrom(BT.class, PropagationBackward.class.getName(), false);
    private String[] order1List = Remote.getArrayFrom(AC.class, PropagationForward.class.getName(), false);
    private String[] order2List = Remote.getArrayFrom(SecondOrderConsistency.class, SecondOrderConsistency.class.getName(), false);
    private String[] softList = Remote.getArrayFrom(LowerBoundCapability.class, Propagation.class.getName(), false);
    private String[] revisionList = Remote.getArrayFrom(Reviser.class, Reviser.class.getName(), false);

    public PanelPropagation(Remote remote) {
        this.remote = remote;
        this.setLayout(new BoxLayout(this, 1));
        JPanel radioPanel = new JPanel();
        ButtonGroup g = new ButtonGroup();
        ActionListener listener = arg0 -> {
            this.propCombo.setModel(new DefaultComboBoxModel<String>(this.backward.isSelected() ? this.backwardList : (this.order1.isSelected() ? this.order1List : (this.order2.isSelected() ? this.order2List : (this.soft.isSelected() ? this.softList : new String[]{})))));
            this.repaint();
        };
        this.backward = Remote.addRadio(BACKWARD, g, radioPanel, listener);
        this.order1 = Remote.addRadio(ORDER_1, g, radioPanel, listener);
        this.order2 = Remote.addRadio(ORDER_2, g, radioPanel, listener);
        this.soft = Remote.addRadio(SOFT, g, radioPanel, listener);
        this.order1.setSelected(true);
        this.add(radioPanel);
        JPanel propPanel = new JPanel();
        propPanel.add(new JLabel(PROPAGATION));
        this.propCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.order1List));
        propPanel.add(this.propCombo);
        this.add(propPanel);
        JPanel revPanel = new JPanel();
        revPanel.add(new JLabel(REVISION));
        this.revCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.revisionList));
        revPanel.add(this.revCombo);
        this.revCombo.setSelectedIndex(0);
        this.add(revPanel);
        JPanel supportPanel = new JPanel();
        this.support = new JCheckBox(SUPPORT);
        supportPanel.add(this.support);
        this.add(supportPanel);
        JPanel applyPanel = new JPanel();
        ((JButton)applyPanel.add(new JButton(APPLY))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelPropagation.this.applyChanges();
            }
        });
        this.add(applyPanel);
    }

    public void applyChanges() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null) {
            String propagationName = this.propCombo.getSelectedItem().toString();
            String revisionName = this.revCombo.getSelectedItem().toString();
            if (propagationName != null && !propagationName.equals(resolution.cp.propagating.clazz)) {
                resolution.cp.propagating.clazz = propagationName;
                resolution.solver.propagation = Reflector.buildObject(propagationName, Propagation.class, resolution.solver);
                System.out.println("MODIF : propagation is now " + propagationName);
            }
            if (resolution.solver.propagation instanceof PropagationForward && !revisionName.equals(resolution.cp.propagating.classForRevisions)) {
                resolution.cp.propagating.classForRevisions = revisionName;
                ((PropagationForward)resolution.solver.propagation).reviser = Reflector.buildObject(revisionName, Reviser.class, resolution.solver.propagation);
                System.out.println("MODIF : revision manager is now " + revisionName);
            }
            if (resolution.cp.propagating.residues != this.support.isSelected()) {
                resolution.cp.propagating.residues = this.support.isSelected();
                System.out.println("MODIF : set use Residues to " + this.support.isSelected());
                for (Constraint ctr : resolution.problem.constraints) {
                    ctr.buildSupporter();
                }
            }
        }
    }

    public void solverStarted() {
    }
}

