/*
 * Decompiled with CFR 0.152.
 */
package tools.output;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.stream.IntStream;

public class CreateLatexTable {
    static final int TIME_OUT = -1;
    static final int ERROR = -2;
    static final int ABSENT = -3;
    static final int UNRANKED = -4;
    static final int CRASHED = -5;
    private static long deadlineTime = 12000000000L;
    static int PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM = 8;
    private static final String FONTSIZE = "tiny";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String GREY = "grey";
    private static final double MODE1_COLOR_OFFSET = 0.25;
    private static final double MODE2_COLOR_OFFSET = 0.45;
    private static final int MAX_INSTANCE_NAME_LENGTH = 40;
    private static final int INSTANCE_NAME_WIDTH = 3;
    private static String[] unsolvedNames = new String[]{"Uns", "Out", "Err", "Abs"};
    private static int nbMethods;
    private static int nbSeriesOfMethods;
    private static int nbMetricsPerMethod;
    private static int nbWishedMetricsPerMethod;
    private static int[][] trame;
    private static String[] columnsNames;
    private static String[] subcolumnsNames;
    private static String[] rowNames;
    private static int[][] statisticsOfSolved;
    private static int[][] statisticsOfUnsolved;
    private static int dataToBeRanked;
    private static int dataToBeAveraged;
    private static int mode;
    private static boolean onlyFirst;
    private static boolean tabular;
    private static boolean insertCommas;
    private static Stats stats;
    private static boolean activateLineSelection;
    private static int minimalSelectionTime;
    private static boolean discardIndividualInstances;

    private static String columnsFormat() {
        String s = "|c|c|";
        for (int i = 0; i < trame[0].length; ++i) {
            s = s + "r|";
        }
        return s;
    }

    private static String header() {
        String inst = "$Instances$";
        String s = "\\hline";
        String spaceBeforeAfterColumnName = "";
        s = s + (trame.length == 1 ? inst : (subcolumnsNames == null ? inst + " & " : "\\multirow{2}{3cm}{" + inst + "} &"));
        if (subcolumnsNames == null) {
            for (int i = 0; i < columnsNames.length; ++i) {
                s = s + " & \\multicolumn{1}{c|}{$" + spaceBeforeAfterColumnName + columnsNames[i] + spaceBeforeAfterColumnName + "$} ";
            }
        } else {
            int i;
            for (i = 0; i < columnsNames.length; ++i) {
                s = s + " & \\multicolumn{" + subcolumnsNames.length + "}{c|}{$" + spaceBeforeAfterColumnName + columnsNames[i] + spaceBeforeAfterColumnName + "$} ";
            }
            s = s + " \\\\";
            s = s + "\\cline{3-" + (trame[0].length + 2) + "}";
            s = s + " & ";
            for (i = 0; i < columnsNames.length; ++i) {
                for (int j = 0; j < subcolumnsNames.length; ++j) {
                    s = s + " & " + subcolumnsNames[j];
                }
            }
        }
        return s + " \\\\";
    }

    private static String getLatexFormatOf(String color, String s) {
        if (mode == 0) {
            return s;
        }
        if (mode == 1) {
            return "\\textcolor{" + color + "}{" + s + "}";
        }
        return "\\cellcolor{" + color + "}" + s;
    }

    private static String getLatexColorDefinitionOf(String color, int level) {
        String s = "\\definecolor{" + color + level + "}{rgb}";
        if (color.equals(GREY)) {
            if (level == 1) {
                return s + "{0.8,0.8,0.8}";
            }
            if (level == 2) {
                return s + "{0.5,0.5,0.5}";
            }
        }
        double offset = (double)(level - 1) * (mode == 1 ? 0.25 : 0.45);
        if (color.equals(RED)) {
            return s + "{1," + offset + "," + offset + "}";
        }
        if (color.equals(GREEN)) {
            return s + "{" + offset + ",1," + offset + "}";
        }
        return s + "{" + offset + "," + offset + ",1}";
    }

    private static String insertCommas(String formatedToken) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (int i = formatedToken.length() - 1; i >= 0; --i) {
            char c = formatedToken.charAt(i);
            sb.insert(0, c);
            if (c == '.' || c == 'M' || c == 'K') {
                cnt = 0;
                continue;
            }
            if (++cnt != 3 || i == 0) continue;
            sb.insert(0, ',');
            cnt = 0;
        }
        return sb.toString();
    }

    private static String format(long d, int rank, int serie) {
        String formatedToken = null;
        if (rank == -3) {
            return "Abs";
        }
        if (rank == -2) {
            return "Err";
        }
        if (rank == -1 && d != -1L) {
            d = Math.abs(d);
        }
        if (serie == 0) {
            if ((d -= d % 10L) > 100000L) {
                d -= d % 1000L;
            } else if (d > 10000L) {
                d -= d % 100L;
            }
            double dd = (double)d / 1000.0;
            formatedToken = rank == -1 || dd > 100.0 ? (long)dd + "" : dd + "";
        } else {
            formatedToken = d > 10000000L ? Math.round((double)d / 1000000.0) + "M" : (d > 100000L ? Math.round((double)d / 1000.0) + "K" : d + "");
        }
        if (insertCommas) {
            formatedToken = CreateLatexTable.insertCommas(formatedToken);
        }
        String s = "$" + formatedToken + "$";
        if (rank == -1) {
            return CreateLatexTable.getLatexFormatOf("grey2", s);
        }
        if (rank == nbMethods) {
            return CreateLatexTable.getLatexFormatOf("red1", s);
        }
        if (rank == nbMethods - 1) {
            return CreateLatexTable.getLatexFormatOf("red2", s);
        }
        if (rank == nbMethods - 2) {
            return CreateLatexTable.getLatexFormatOf("red3", s);
        }
        if (rank == 1) {
            return onlyFirst ? CreateLatexTable.getLatexFormatOf("grey1", s) : CreateLatexTable.getLatexFormatOf("green1", s);
        }
        if (rank == 2) {
            return CreateLatexTable.getLatexFormatOf("green2", s);
        }
        if (rank == 3) {
            return CreateLatexTable.getLatexFormatOf("green3", s);
        }
        return s;
    }

    private static long getValue(String s, int position) {
        StringTokenizer st = new StringTokenizer(s);
        for (int i = 0; i < position - 1; ++i) {
            st.nextToken();
        }
        return (long)Double.parseDouble(st.nextToken());
    }

    private static void rank(long[] values, int[] rankings, int rank) {
        long bestValue = Long.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (rankings[i] != -4 || values[i] >= bestValue) continue;
            bestValue = values[i];
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return;
        }
        if (bestValue == 0L) {
            rankings[bestIndex] = 1;
            int[] nArray = statisticsOfSolved[bestIndex];
            nArray[1] = nArray[1] + 1;
        } else {
            rankings[bestIndex] = rank;
            int[] nArray = statisticsOfSolved[bestIndex];
            int n = rank;
            nArray[n] = nArray[n] + 1;
        }
    }

    private static int[] rankingOf(String line, int data) {
        int i;
        int[] rankings = new int[nbMethods];
        Arrays.fill(rankings, -4);
        if (data != dataToBeRanked || nbSeriesOfMethods > 1) {
            return rankings;
        }
        long[] values = new long[nbMethods];
        for (int i2 = 0; i2 < nbMethods; ++i2) {
            values[i2] = CreateLatexTable.getValue(line, trame[data][i2]);
        }
        int nbSuccesfulMethods = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] == -2L) {
                rankings[i] = -2;
                int[] nArray = statisticsOfUnsolved[i];
                nArray[0] = nArray[0] + 1;
                int[] nArray2 = statisticsOfUnsolved[i];
                nArray2[2] = nArray2[2] + 1;
                continue;
            }
            if (values[i] == -3L) {
                rankings[i] = -3;
                int[] nArray = statisticsOfUnsolved[i];
                nArray[0] = nArray[0] + 1;
                int[] nArray3 = statisticsOfUnsolved[i];
                nArray3[3] = nArray3[3] + 1;
                continue;
            }
            if (values[i] < 0L || values[i] >= deadlineTime) {
                System.out.println(values[i] + " " + deadlineTime);
                rankings[i] = -1;
                int[] nArray = statisticsOfUnsolved[i];
                nArray[0] = nArray[0] + 1;
                int[] nArray4 = statisticsOfUnsolved[i];
                nArray4[1] = nArray4[1] + 1;
                continue;
            }
            ++nbSuccesfulMethods;
            int[] nArray = statisticsOfSolved[i];
            nArray[0] = nArray[0] + 1;
        }
        if (onlyFirst) {
            CreateLatexTable.rank(values, rankings, 1);
        } else {
            for (i = 1; i <= nbSuccesfulMethods; ++i) {
                CreateLatexTable.rank(values, rankings, i);
            }
        }
        return rankings;
    }

    private static String getInstanceName(String s) {
        int position2;
        int position1 = s.lastIndexOf(File.separatorChar);
        if (position1 != -1) {
            s = s.substring(position1 + 1);
        }
        if ((position2 = s.lastIndexOf(".xml")) != -1) {
            s = s.substring(0, position2);
        }
        if (s.length() > 40) {
            s = s.substring(s.length() - 40);
        }
        return trame.length == 1 ? s : "\\multirow{" + trame.length + "}{" + 3 + "cm}{" + s + "}";
    }

    private static boolean discardLine(String line, int serie) {
        int i;
        if (!activateLineSelection) {
            return false;
        }
        if (serie != 0) {
            return false;
        }
        boolean allTimedOut = true;
        for (i = 0; allTimedOut && i < trame[serie].length; ++i) {
            if (CreateLatexTable.getValue(line, trame[serie][i]) >= deadlineTime) continue;
            allTimedOut = false;
        }
        if (allTimedOut) {
            return true;
        }
        for (i = 0; i < trame[serie].length; ++i) {
            if (CreateLatexTable.getValue(line, trame[serie][i]) <= (long)minimalSelectionTime) continue;
            return false;
        }
        return true;
    }

    private static String dealWith(String line, int data) {
        String s;
        if (discardIndividualInstances) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(line);
        String instanceName = CreateLatexTable.getInstanceName(st.nextToken());
        String string = s = data == 0 ? "$" + instanceName.replaceAll("_", "-") + "$" : " ";
        if (trame.length > 1) {
            s = s + " & " + rowNames[data];
        }
        int[] rankings = CreateLatexTable.rankingOf(line, data);
        for (int i = 0; i < trame[data].length; ++i) {
            s = s + " & " + CreateLatexTable.format(CreateLatexTable.getValue(line, trame[data][i]), nbSeriesOfMethods > 1 ? Integer.MAX_VALUE : rankings[i], data);
        }
        return s + " \\\\";
    }

    private static String getStatisticsOfSolved(int rank) {
        String s = rank == 0 ? " & sol " : " & nb " + rank;
        for (int i = 0; i < statisticsOfSolved.length; ++i) {
            s = s + " & " + statisticsOfSolved[i][rank];
        }
        return s + " \\\\";
    }

    private static String getStatisticsOfUnsolved(int position) {
        String s = " & " + unsolvedNames[position];
        for (int i = 0; i < statisticsOfUnsolved.length; ++i) {
            s = s + " & " + statisticsOfUnsolved[i][position];
        }
        return s + " \\\\";
    }

    private static void createHorizontalTable(File inFile, File outFile) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
        out.println(CreateLatexTable.getLatexColorDefinitionOf(GREY, 1));
        out.println(CreateLatexTable.getLatexColorDefinitionOf(GREY, 2));
        for (int i = 1; i <= 3; ++i) {
            out.println(CreateLatexTable.getLatexColorDefinitionOf(RED, i));
            out.println(CreateLatexTable.getLatexColorDefinitionOf(GREEN, i));
            out.println(CreateLatexTable.getLatexColorDefinitionOf(BLUE, i));
        }
        out.println();
        if (tabular) {
            out.println("\\begin{table}");
            out.println("{\\tiny");
            out.println("\\begin{center}");
            out.println("\\begin{tabular}{" + CreateLatexTable.columnsFormat() + "}");
            out.println(CreateLatexTable.header());
        } else {
            out.println("{\\tiny");
            out.println("\\begin{center}");
            out.println("\\begin{longtable}{" + CreateLatexTable.columnsFormat() + "}");
            out.println(CreateLatexTable.header());
            out.println("\\endfirsthead");
            out.println(CreateLatexTable.header());
            out.println("\\endhead");
            out.println("\\hline");
            out.println("\\endfoot");
            out.println("\\hline");
            out.println("\\endlastfoot");
        }
        String line = in.readLine();
        line = in.readLine();
        int cpt = 0;
        while (line != null) {
            if (line.trim().equals("") || line.startsWith("#")) {
                line = in.readLine();
                continue;
            }
            int data = cpt % trame.length;
            if (!CreateLatexTable.discardLine(line, data)) {
                if (data == dataToBeAveraged) {
                    CreateLatexTable.stats.manageNewLine(line, data, out);
                }
                String dealtLine = CreateLatexTable.dealWith(line, data);
                if (data == 0 && !discardIndividualInstances) {
                    out.println("\\hline");
                }
                out.println(dealtLine);
            } else {
                cpt += trame.length - 1;
                data = trame.length - 1;
            }
            line = data == trame.length - 1 ? in.readLine() : line;
            ++cpt;
        }
        if (stats.previousLine != null) {
            CreateLatexTable.stats.printProblemEasyInstances(out);
            CreateLatexTable.stats.printProblemInstances(out);
        }
        out.println("\\hline");
        if (dataToBeRanked != -1 && nbSeriesOfMethods == 1) {
            int i;
            out.println(CreateLatexTable.getStatisticsOfSolved(0));
            if (onlyFirst) {
                out.println(CreateLatexTable.getStatisticsOfSolved(1));
            } else {
                for (i = 1; i <= nbMethods; ++i) {
                    out.println(CreateLatexTable.getStatisticsOfSolved(i));
                }
            }
            out.println("\\hline");
            for (i = 0; i < unsolvedNames.length; ++i) {
                out.println(CreateLatexTable.getStatisticsOfUnsolved(i));
            }
            out.println("\\hline");
        }
        if (dataToBeRanked != -1) {
            CreateLatexTable.stats.printEasyInstances(out);
        }
        if (tabular) {
            out.println("\\end{tabular}");
            out.println("\\end{center}");
            out.println("}");
            out.println("\\caption{ the caption } \\label{tab:}");
            out.println("\\end{table}");
        } else {
            out.println("\\end{longtable}");
            out.println("\\end{center}");
            out.println("}");
        }
        in.close();
        out.close();
    }

    private static File buildInFile(String inputFileName) {
        File inFile = new File(inputFileName);
        assert (!inFile.isDirectory()) : inputFileName + " is a directory";
        assert (inFile.exists() && inFile.length() > 0L) : inputFileName + " is not a file that does exist or it is empty";
        return inFile;
    }

    private static File buildOutFile(String inputFileName) {
        int position = inputFileName.lastIndexOf(".");
        String outputFileName = (position == -1 ? inputFileName : inputFileName.substring(0, position)) + ".tex";
        File outFile = new File(outputFileName);
        assert (!outFile.isDirectory()) : outputFileName + " is a directory";
        return outFile;
    }

    private static int[] buildIntArrayByParsing(int length, String[] ts, int startingIndex) {
        return IntStream.range(0, length).map(i -> Integer.parseInt(ts[i + startingIndex])).toArray();
    }

    public static void main(String[] args) throws Exception {
        int j;
        int i;
        if (args.length == 0) {
            System.out.println("Usage: " + CreateLatexTable.class.getName() + " <inputFileName> <nbVariants> <nbSeriesOfVariants> (<orderOfSeries>) <nbMetricsPerVariant> <nbSelectedMetrics> <selectedVariants> <selectedMetrics> <columnNames> (<subcolumnNames>) (<rowNames>) [prefixLength [selectionTimeLimit deadlineTime [discardInstances (0/1)]] ] ]");
            System.out.println("The usual case is to have the number of series of variants equal to 1.");
            System.out.println("For selecting methods and data, give the order (from 1) of methods and data to be selected");
            System.out.println("For selecting methods and data, give the order (from 1) of methods and data to be selected");
            return;
        }
        int cnt = 0;
        String inputFileName = args[cnt++];
        File inFile = CreateLatexTable.buildInFile(inputFileName);
        File outFile = CreateLatexTable.buildOutFile(inputFileName);
        nbMethods = Integer.parseInt(args[cnt++]);
        nbSeriesOfMethods = Integer.parseInt(args[cnt++]);
        int[] orderOfSeries = null;
        if (nbSeriesOfMethods > 1) {
            orderOfSeries = CreateLatexTable.buildIntArrayByParsing(nbSeriesOfMethods, args, cnt);
            cnt += nbSeriesOfMethods;
        }
        nbMetricsPerMethod = Integer.parseInt(args[cnt++]);
        nbWishedMetricsPerMethod = Integer.parseInt(args[cnt++]);
        int[] selectionOfMethods = CreateLatexTable.buildIntArrayByParsing(nbMethods, args, cnt);
        System.out.println("firstSelectionOfMethods = " + selectionOfMethods[0] + " lastSelectionOfMethods = " + selectionOfMethods[selectionOfMethods.length - 1]);
        int[] selectionOfData = CreateLatexTable.buildIntArrayByParsing(nbWishedMetricsPerMethod, args, cnt += nbMethods);
        cnt += nbWishedMetricsPerMethod;
        System.out.println("firstSelectionOfData = " + selectionOfData[0] + " lastSelectionOfData = " + selectionOfData[selectionOfData.length - 1]);
        if (nbSeriesOfMethods == 1) {
            trame = new int[nbWishedMetricsPerMethod][nbMethods];
            for (i = 0; i < trame.length; ++i) {
                for (j = 0; j < trame[i].length; ++j) {
                    CreateLatexTable.trame[i][j] = 2 + nbMetricsPerMethod * (selectionOfMethods[j] - 1) + (selectionOfData[i] - 1);
                }
            }
        } else {
            trame = new int[nbSeriesOfMethods][nbMethods / nbSeriesOfMethods * nbWishedMetricsPerMethod];
            for (i = 0; i < trame.length; ++i) {
                for (j = 0; j < nbMethods / nbSeriesOfMethods; ++j) {
                    for (int k = 0; k < nbWishedMetricsPerMethod; ++k) {
                        int column = j * nbSeriesOfMethods + (orderOfSeries[i] - 1);
                        CreateLatexTable.trame[i][j * CreateLatexTable.nbWishedMetricsPerMethod + k] = 2 + nbMetricsPerMethod * (selectionOfMethods[column] - 1) + (selectionOfData[k] - 1);
                    }
                }
            }
        }
        columnsNames = new String[nbMethods / nbSeriesOfMethods];
        for (i = 0; i < columnsNames.length; ++i) {
            CreateLatexTable.columnsNames[i] = args[cnt++];
        }
        System.out.println("firstColumnName = " + columnsNames[0] + " lastColumnName = " + columnsNames[columnsNames.length - 1]);
        if (nbSeriesOfMethods > 1 && nbWishedMetricsPerMethod > 1) {
            subcolumnsNames = new String[nbWishedMetricsPerMethod];
            for (i = 0; i < subcolumnsNames.length; ++i) {
                CreateLatexTable.subcolumnsNames[i] = args[cnt++];
            }
        }
        if (trame.length > 1) {
            rowNames = new String[trame.length];
            for (i = 0; i < rowNames.length; ++i) {
                CreateLatexTable.rowNames[i] = "$" + args[cnt++] + "$";
            }
            System.out.println("firstRowName = " + rowNames[0] + " lastRowName = " + rowNames[rowNames.length - 1]);
        }
        if (cnt < args.length) {
            PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM = Integer.parseInt(args[cnt++]);
        }
        if (cnt < args.length) {
            activateLineSelection = true;
            minimalSelectionTime = Integer.parseInt(args[cnt++]) * 1000;
        }
        if (cnt < args.length) {
            deadlineTime = Integer.parseInt(args[cnt++]) * 1000;
        }
        if (cnt < args.length) {
            discardIndividualInstances = Integer.parseInt(args[cnt++]) == 1;
        }
        statisticsOfSolved = new int[nbMethods][nbMethods + 1];
        statisticsOfUnsolved = new int[nbMethods][unsolvedNames.length + 1];
        CreateLatexTable.createHorizontalTable(inFile, outFile);
    }

    static {
        dataToBeRanked = 0;
        dataToBeAveraged = 0;
        mode = 2;
        onlyFirst = false;
        tabular = false;
        insertCommas = true;
        stats = new Stats();
        activateLineSelection = false;
        minimalSelectionTime = 5000;
        discardIndividualInstances = false;
    }

    private static class Stats {
        private int nbEasyInstances;
        private long[] sumEasyInstances;
        private int nbProblemEasyInstances;
        private long[] sumProblemEasyInstances;
        private int[] nbSolvedProblemInstances;
        private long[] sumSolvedProblemInstances;
        private String previousLine;
        private int nbProblemInstances;

        private Stats() {
        }

        private void printLineFor(int nb, long[] t, String head, PrintWriter out) {
            if (this.previousLine == null) {
                return;
            }
            out.println("\\hline");
            String problemName = this.previousLine.substring(0, PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM).replaceAll("_", "\\\\_") + " (" + this.nbProblemInstances + ") ";
            String result = problemName + " & " + head + " ";
            for (int i = 0; i < t.length; ++i) {
                result = result + " & " + (nb != 0 ? Long.valueOf(t[i] / (long)nb) : "-") + "(" + nb + ")";
            }
            result = result + " \\\\";
            out.println(result);
            out.println("\\hline");
        }

        private void printLineFor(int[] nb, long[] t, String head, PrintWriter out) {
            String problemName = this.previousLine.substring(0, PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM).replaceAll("_", "\\\\_") + " (" + this.nbProblemInstances + ") ";
            String result = problemName + " & " + head + " ";
            for (int i = 0; i < t.length; ++i) {
                result = result + " & " + (nb[i] != 0 ? Long.valueOf(t[i] / (long)nb[i]) : "-") + "(" + nb[i] + ")";
            }
            result = result + " \\\\";
            out.println(result);
            out.println("\\hline");
        }

        private void printEasyInstances(PrintWriter out) {
            this.printLineFor(this.nbEasyInstances, this.sumEasyInstances, "avgE", out);
        }

        private void printProblemEasyInstances(PrintWriter out) {
            this.printLineFor(this.nbProblemEasyInstances, this.sumProblemEasyInstances, "avgE", out);
        }

        private void printProblemInstances(PrintWriter out) {
            this.printLineFor(this.nbSolvedProblemInstances, this.sumSolvedProblemInstances, "avgT", out);
        }

        private boolean isArrayContainingValuesStrictlyLessThanOnly(long[] t, long limit) {
            for (long v : t) {
                if (v < limit) continue;
                return false;
            }
            return true;
        }

        private void manageNewLine(String line, int dataToBeAveraged, PrintWriter out) {
            int i;
            System.out.println(line);
            if (nbSeriesOfMethods != 1) {
                return;
            }
            long[] values = new long[nbMethods];
            for (int i2 = 0; i2 < nbMethods; ++i2) {
                values[i2] = CreateLatexTable.getValue(line, trame[dataToBeAveraged][i2]);
            }
            if (this.previousLine == null) {
                this.sumEasyInstances = new long[nbMethods];
                this.sumSolvedProblemInstances = new long[nbMethods];
                this.sumProblemEasyInstances = new long[nbMethods];
                this.nbSolvedProblemInstances = new int[nbMethods];
            }
            boolean easyInstance = dataToBeAveraged != 0 || Arrays.stream(values).noneMatch(v -> v < 0L) && this.isArrayContainingValuesStrictlyLessThanOnly(values, deadlineTime);
            boolean newProblem = this.previousLine != null && !this.previousLine.startsWith(line.substring(0, PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM));
            boolean bl = newProblem = newProblem && (this.nbProblemInstances >= 10 || !this.previousLine.startsWith(line.substring(0, PREFIX_LENGTH_FOR_INSTANCES_OF_SIMILAR_PROBLEM / 2)));
            if (newProblem) {
                if (this.nbProblemInstances > 1) {
                    this.printProblemEasyInstances(out);
                    this.printProblemInstances(out);
                }
                this.nbProblemInstances = 0;
                this.nbProblemEasyInstances = 0;
                Arrays.fill(this.sumProblemEasyInstances, 0L);
                Arrays.fill(this.sumSolvedProblemInstances, 0L);
                Arrays.fill(this.nbSolvedProblemInstances, 0);
            }
            ++this.nbProblemInstances;
            this.previousLine = line;
            if (easyInstance) {
                ++this.nbEasyInstances;
                for (i = 0; i < values.length; ++i) {
                    int n = i;
                    this.sumEasyInstances[n] = this.sumEasyInstances[n] + values[i];
                }
                ++this.nbProblemEasyInstances;
                for (i = 0; i < values.length; ++i) {
                    int n = i;
                    this.sumProblemEasyInstances[n] = this.sumProblemEasyInstances[n] + values[i];
                }
            }
            for (i = 0; i < values.length; ++i) {
                if (values[i] < 0L || values[i] >= deadlineTime) continue;
                int n = i;
                this.nbSolvedProblemInstances[n] = this.nbSolvedProblemInstances[n] + 1;
                int n2 = i;
                this.sumSolvedProblemInstances[n2] = this.sumSolvedProblemInstances[n2] + values[i];
            }
        }
    }
}

