/*
 * Decompiled with CFR 0.152.
 */
package search.statistics;

import dashboard.Arguments;
import executables.Resolution;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import propagation.order1.inverse.GIC4;
import search.statistics.Statistics;
import utility.Enums;
import utility.Kit;

public abstract class StatisticsMultiResolution {
    public abstract void update(boolean var1);

    public abstract void outputGlobalStatistics();

    public static StatisticsMultiResolution build(Resolution resolution) {
        return Arguments.nInstancesToSolve > 1 ? new ActiveStatisticsMultiResolution(resolution) : new VoidStatisticsMultiResolution();
    }

    private static class ActiveStatisticsMultiResolution
    extends StatisticsMultiResolution {
        private Resolution resolution;
        private QuickStatistics[] satStatistics;
        private QuickStatistics[] unsatStatistics;
        private QuickStatistics[] unknownStatistics;
        private QuickStatistics[] expiredStatistics;
        private QuickStatistics[] allStatistics;
        private QuickStatistics[] crashedStatistics;

        public ActiveStatisticsMultiResolution(Resolution resolution) {
            this.resolution = resolution;
            int nbAbstractionLevels = 0;
            if (Arguments.nInstancesToSolve > 1) {
                int i;
                this.satStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.satStatistics.length; ++i) {
                    this.satStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.SAT);
                }
                this.unsatStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.unsatStatistics.length; ++i) {
                    this.unsatStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.UNSAT);
                }
                this.unknownStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.unknownStatistics.length; ++i) {
                    this.unknownStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.UNKNOWN);
                }
                this.expiredStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.expiredStatistics.length; ++i) {
                    this.expiredStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.EXPIRED);
                }
                this.allStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.allStatistics.length; ++i) {
                    this.allStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.ALL);
                }
                this.crashedStatistics = new QuickStatistics[nbAbstractionLevels + 1];
                for (i = 0; i < this.crashedStatistics.length; ++i) {
                    this.crashedStatistics[i] = new QuickStatistics(i, Enums.TypeOutput.CRASHED);
                }
            }
        }

        @Override
        public void update(boolean crashed) {
            if (crashed) {
                this.crashedStatistics[0].nbTreatedInstances++;
            } else {
                if (this.resolution.solver == null || this.resolution.solver.stats == null) {
                    return;
                }
                Statistics stats = this.resolution.solver.stats;
                if (this.resolution.isTimeExpiredForCurrentInstance()) {
                    this.expiredStatistics[0].updateStatisticsWith(stats);
                } else if (stats.solver.solManager.nSolutionsFound > 0L) {
                    this.satStatistics[0].updateStatisticsWith(stats);
                } else if (this.resolution.solver.isFullExploration()) {
                    this.unsatStatistics[0].updateStatisticsWith(stats);
                } else {
                    this.unknownStatistics[0].updateStatisticsWith(stats);
                }
                this.allStatistics[0].updateStatisticsWith(stats);
                this.allStatistics[0].updateForMedian(stats.solvingWck, !this.resolution.isTimeExpiredForCurrentInstance() && (stats.solver.solManager.nSolutionsFound > 0L || this.resolution.solver.isFullExploration()));
            }
        }

        @Override
        public void outputGlobalStatistics() {
            for (int i = 0; i < this.expiredStatistics.length; ++i) {
                this.expiredStatistics[i].display();
                this.satStatistics[i].display();
                this.unsatStatistics[i].display();
                this.unknownStatistics[i].display();
                this.allStatistics[i].display();
                this.crashedStatistics[i].display();
            }
        }

        private class QuickStatistics {
            private Enums.TypeOutput outputElement;
            private int nbTreatedInstances;
            private long preproWckTime;
            private long searchWckTime;
            private long allCpuTime;
            private long sumOfNbSingletonTests;
            private long sumOfNbEffectiveSingletonTests;
            private long sumOfNbConstraintChecks;
            private long sumOfNbPropagations;
            private long sumOfNbAssignments;
            private long sumOfNbFailedAssignments;
            private long sumOfNbSolutions;
            private long nbPreproValuesRemoved;
            private long nbPreproTuplesRemoved;
            private int nbPreproInconsistencies;
            private int nbSuccesses;
            private long[] durationsToRunSolver;
            private long memory;
            private int[] nbRemovedValues;
            private long nbFilterCallsSTR;
            private double sumTableProportionsSTR;
            private double sumTableSizesSTR;
            private long nbVals;
            private long nbUnks;
            private long nbUnksAfterAC;
            private long nbTests;
            private long wcks;
            private long minWck = Long.MAX_VALUE;
            private long maxWck = Long.MIN_VALUE;
            private long nbITestRestor;

            QuickStatistics(int level, Enums.TypeOutput outputElement) {
                this.outputElement = outputElement;
            }

            void updateStatisticsWith(Statistics statistics) {
                if (((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.cp.experimental.helene) {
                    int[] t = ((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.solManager.tmpHelene;
                    if (this.nbRemovedValues == null) {
                        this.nbRemovedValues = new int[t.length];
                    } else if (t.length > this.nbRemovedValues.length) {
                        int[] tmp = new int[t.length];
                        System.arraycopy(this.nbRemovedValues, 0, tmp, 0, this.nbRemovedValues.length);
                        this.nbRemovedValues = tmp;
                    }
                    for (int i = 0; i < Math.min(t.length, this.nbRemovedValues.length); ++i) {
                        int n = i;
                        this.nbRemovedValues[n] = this.nbRemovedValues[n] + t[i];
                    }
                }
                if (((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.nFilterCallsSTR > 0) {
                    this.nbFilterCallsSTR += (long)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.nFilterCallsSTR;
                    this.sumTableProportionsSTR += ((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.sumTableProportionsSTR / (double)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.nFilterCallsSTR;
                    this.sumTableSizesSTR += ((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.sumTableSizesSTR / (double)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.problem.stuff.nFilterCallsSTR;
                }
                ++this.nbTreatedInstances;
                this.preproWckTime += statistics.preproWck;
                this.searchWckTime += statistics.searchWck;
                this.sumOfNbSingletonTests += statistics.nSingletonTests();
                this.sumOfNbEffectiveSingletonTests += statistics.nEffectiveSingletonTests();
                this.sumOfNbConstraintChecks += statistics.nCcks();
                this.sumOfNbPropagations = statistics.nEffectiveFilterings();
                this.sumOfNbAssignments += statistics.nAssignments;
                this.sumOfNbFailedAssignments += statistics.nFailedAssignments;
                this.sumOfNbSolutions += statistics.solver.solManager.nSolutionsFound;
                this.nbPreproValuesRemoved += statistics.nPreproRemovedValues;
                this.nbPreproTuplesRemoved += statistics.nPreproRemovedTuples;
                this.nbPreproInconsistencies = (int)((long)this.nbPreproInconsistencies + statistics.nPreproInconsistencies);
                this.memory += Kit.getUsedMemory();
                if (((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation instanceof GIC4) {
                    this.nbVals += (long)((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).nVals;
                    this.nbUnks += (long)((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).nUnks;
                    this.nbUnksAfterAC += (long)((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).nUnksAfterAC;
                    this.nbTests += (long)((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).nTests;
                    this.wcks += ((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).wck;
                    this.minWck = Math.min(this.minWck, ((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).wck);
                    this.maxWck = Math.max(this.maxWck, ((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).wck);
                    this.nbITestRestor += ((GIC4)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.solver.propagation).nItestsRestor;
                }
            }

            void updateForMedian(long durationToRunSolver, boolean success) {
                if (this.durationsToRunSolver == null) {
                    this.durationsToRunSolver = new long[Arguments.nInstancesToSolve];
                }
                if (success) {
                    this.durationsToRunSolver[this.nbTreatedInstances - 1] = durationToRunSolver;
                    ++this.nbSuccesses;
                } else {
                    this.durationsToRunSolver[this.nbTreatedInstances - 1] = Long.MAX_VALUE;
                }
            }

            long computeMedian() {
                int nbInstances = Arguments.nInstancesToSolve;
                if (this.nbSuccesses < nbInstances / 2 + 1) {
                    return -1L;
                }
                Arrays.sort(this.durationsToRunSolver);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.durationsToRunSolver.length; ++i) {
                    sb.append(this.durationsToRunSolver[i] + " ");
                }
                if (nbInstances % 2 == 0) {
                    return (this.durationsToRunSolver[nbInstances / 2] + this.durationsToRunSolver[nbInstances / 2 - 1]) / 2L;
                }
                return this.durationsToRunSolver[nbInstances / 2];
            }

            public Map<String, Object> getMapOfCumulatedAttributes() {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("nInstances", this.nbTreatedInstances);
                if (this.nbTreatedInstances != 0) {
                    map.put("preproWckTime", this.preproWckTime / (long)this.nbTreatedInstances);
                    map.put("searchWckTime", this.searchWckTime / (long)this.nbTreatedInstances);
                    map.put("solvingCpuTime", this.allCpuTime / (long)this.nbTreatedInstances);
                    if (this.durationsToRunSolver != null) {
                        map.put("medianCpuTime", this.computeMedian());
                    }
                    if (this.sumOfNbSingletonTests != 0L) {
                        map.put("nSingletonTests", this.sumOfNbSingletonTests / (long)this.nbTreatedInstances);
                    }
                    if (this.sumOfNbEffectiveSingletonTests != 0L) {
                        map.put("nEffectiveSingletonTests", this.sumOfNbEffectiveSingletonTests / (long)this.nbTreatedInstances);
                    }
                    map.put("nConstraintChecks", this.sumOfNbConstraintChecks / (long)this.nbTreatedInstances);
                    map.put("nEffectivePFilterings", this.sumOfNbPropagations / (long)this.nbTreatedInstances);
                    map.put("nAssignments", (double)this.sumOfNbAssignments / (double)this.nbTreatedInstances);
                    map.put("nFailedAssignments", this.sumOfNbFailedAssignments);
                    map.put("foundSolutions", (double)this.sumOfNbSolutions / (double)this.nbTreatedInstances);
                    map.put("nRemovedValues", (double)this.nbPreproValuesRemoved / (double)this.nbTreatedInstances);
                    map.put("nRemovedTuples", (double)this.nbPreproTuplesRemoved / (double)this.nbTreatedInstances);
                    map.put("nFilterCalls", (double)this.nbFilterCallsSTR / (double)this.nbTreatedInstances);
                    map.put("avgTableProportion", this.sumTableProportionsSTR / (double)this.nbTreatedInstances);
                    map.put("avgTableSize", this.sumTableSizesSTR / (double)this.nbTreatedInstances);
                    map.put("cpu", (double)((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.stopwatch.getCpuTime() / (double)this.nbTreatedInstances);
                    map.put("mem", (long)((double)this.memory / (double)this.nbTreatedInstances));
                    if (((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.cp.experimental.helene) {
                        map.put("NbRemovedValues", Kit.join((Object)this.nbRemovedValues, ";"));
                    }
                    if (this.outputElement == Enums.TypeOutput.UNSAT) {
                        map.put("nPreproInconsistencies", this.nbPreproInconsistencies);
                    }
                    if (((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.cp.experimental.helene) {
                        map.put("nbVals", (double)this.nbVals / (double)this.nbTreatedInstances);
                        map.put("nbUnks", (double)this.nbUnks / (double)this.nbTreatedInstances);
                        map.put("nbUnksAfterAC", (double)this.nbUnksAfterAC / (double)this.nbTreatedInstances);
                        map.put("nbTests", (double)this.nbTests / (double)this.nbTreatedInstances);
                        map.put("wck", (double)this.wcks / (double)this.nbTreatedInstances);
                        map.put("minWck", this.minWck);
                        map.put("maxWck", this.maxWck);
                        map.put("nbITestRestor", (double)this.nbITestRestor / (double)this.nbTreatedInstances);
                    }
                }
                return map;
            }

            void display() {
                Set<Map.Entry<String, Object>> set = this.getMapOfCumulatedAttributes().entrySet();
                ((ActiveStatisticsMultiResolution)ActiveStatisticsMultiResolution.this).resolution.output.printMap(this.outputElement, set);
                System.out.println((Object)this.outputElement);
                set.forEach(e -> System.out.println("\t" + (String)e.getKey() + " : " + e.getValue()));
            }
        }
    }

    private static class VoidStatisticsMultiResolution
    extends StatisticsMultiResolution {
        private VoidStatisticsMultiResolution() {
        }

        @Override
        public void update(boolean crashed) {
        }

        @Override
        public void outputGlobalStatistics() {
        }
    }
}

