/*
 * Decompiled with CFR 0.152.
 */
package search.local.neighborHeuristics;

import search.local.SolverLocal;
import search.local.neighborHeuristics.TabuManager;
import variables.Variable;

public class TabuManagerVariableValue
extends TabuManager {
    private boolean[][] tabus;
    private int[] t1;
    private int[] t2;
    private int head;

    public TabuManagerVariableValue(SolverLocal solver, int tabuListSize) {
        if (tabuListSize > 0) {
            Variable[] variables = solver.pb.variables;
            this.tabus = new boolean[variables.length][];
            for (int i = 0; i < this.tabus.length; ++i) {
                this.tabus[i] = new boolean[variables[i].dom.initSize()];
            }
            this.t1 = new int[tabuListSize];
            this.t2 = new int[tabuListSize];
        }
    }

    @Override
    public void push(Variable var, int idx) {
        if (!this.tabus[var.num][idx]) {
            this.tabus[this.t1[this.head]][this.t2[this.head]] = false;
            this.tabus[var.num][idx] = true;
            this.t1[this.head] = var.num;
            this.t2[this.head] = idx;
            this.head = (this.head + 1) % this.t1.length;
        }
    }

    @Override
    public boolean isTabu(Variable var, int idx) {
        return this.tabus != null && this.tabus[var.num][idx];
    }
}

