/*
 * Decompiled with CFR 0.152.
 */
package search.local.functionalPropagators;

import constraints.CtrHard;
import java.util.List;
import search.local.functionalPropagators.FunctionalPropagatorDirect;
import search.local.functionalPropagators.FunctionalPropagatorPreComputed;
import variables.Variable;

public abstract class FunctionalPropagator {
    protected static final int UNDECIDABLE = Integer.MIN_VALUE;
    private static final int MAX_SIZE_FOR_ENCODING = 1000000;
    public final CtrHard ctr;
    public final int outputPos;

    public static FunctionalPropagator buildFunctionalPropagator(CtrHard constraint, int outputPos) {
        int encodingSize = 1;
        for (int i = 0; i < constraint.scp.length; ++i) {
            if (i == outputPos) continue;
            if (Integer.MAX_VALUE / constraint.scp[i].dom.initSize() < encodingSize) {
                return new FunctionalPropagatorDirect(constraint, outputPos);
            }
            encodingSize *= constraint.scp[i].dom.initSize();
        }
        return encodingSize > 1000000 ? new FunctionalPropagatorDirect(constraint, outputPos) : new FunctionalPropagatorPreComputed(constraint, outputPos, encodingSize);
    }

    public static List<FunctionalPropagator> sort(List<FunctionalPropagator> list) {
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < list.size(); ++i) {
                FunctionalPropagator first = list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    FunctionalPropagator second = list.get(j);
                    if (!first.ctr.involves(second.ctr.scp[second.outputPos])) continue;
                    list.remove(i);
                    list.add(first);
                    sorted = false;
                    break;
                }
                if (sorted) continue;
                sorted = true;
                --i;
            }
        }
        return list;
    }

    public FunctionalPropagator(CtrHard constraint, int outputPos) {
        this.ctr = constraint;
        this.outputPos = outputPos;
    }

    protected abstract int getOutputVal(int[] var1);

    public void propagate() {
        Variable[] constraintScope = this.ctr.scp;
        int[] tuple = new int[constraintScope.length];
        for (int i = 0; i < tuple.length; ++i) {
            tuple[i] = constraintScope[i].dom.unique();
        }
    }
}

