/*
 * Decompiled with CFR 0.152.
 */
package search.local;

import java.util.Collection;
import java.util.List;
import org.xcsp.common.enumerations.EnumerationOfPermutations;
import problem.ProblemStuff;
import search.SolutionManager;
import search.local.functionalPropagators.FunctionalPropagator;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;

public class SolutionOptimizer {
    private static final int MAX_SIZE_FOR_PERMUTATIONS_ENUMERATION = 8;
    private static final int NB_TABU_ITERATIONS = 100;
    private final SolutionManager solManager;
    private List<FunctionalPropagator> costVarsPropagators;
    private Collection<Variable[][]> satPreservingPermutations;
    private boolean areIndependantPermutationSets;

    public SolutionOptimizer(SolutionManager solManager) {
        this.solManager = solManager;
        ProblemStuff.StuffOptimization stuffOptimization = solManager.solver.pb.stuff.stuffOptimization;
        if (!stuffOptimization.collectedSatPreservingPermutationsAtInit.isEmpty()) {
            for (Variable[][] set : stuffOptimization.collectedSatPreservingPermutationsAtInit) {
                for (int i = 1; i < set.length; ++i) {
                    for (int j = 0; j < set[i].length; ++j) {
                        Kit.control(Variable.haveSameDomainType(set[0][j], set[i][j]));
                    }
                }
            }
            this.costVarsPropagators = FunctionalPropagator.sort(stuffOptimization.collectedCostVarsFunctionalPropagatorsAtInit);
            this.satPreservingPermutations = stuffOptimization.collectedSatPreservingPermutationsAtInit;
            this.areIndependantPermutationSets = stuffOptimization.areIndependantPermutationSets;
        }
    }

    public void optimizeCurrentSolution() {
        if (this.costVarsPropagators == null) {
            return;
        }
        if (this.areIndependantPermutationSets) {
            for (Variable[][] permutationSet : this.satPreservingPermutations) {
                this.optimizeCurrentSolution(permutationSet);
            }
        } else {
            throw new MissingImplementationException();
        }
    }

    private void optimizeCurrentSolution(Variable[][] permutationSet) {
        int[][] initialPartialInstantiation = new int[permutationSet.length][permutationSet[0].length];
        for (int i = 0; i < initialPartialInstantiation.length; ++i) {
            for (int j = 0; j < initialPartialInstantiation[i].length; ++j) {
                initialPartialInstantiation[i][j] = permutationSet[i][j].dom.unique();
            }
        }
        if (permutationSet.length <= 8) {
            EnumerationOfPermutations permEnum = new EnumerationOfPermutations(permutationSet.length);
            while (permEnum.hasNext()) {
                this.generateAndTestPermutation(permutationSet, initialPartialInstantiation, permEnum.next());
            }
        } else {
            this.runTabuSearch(permutationSet, initialPartialInstantiation);
        }
    }

    private long generateAndTestPermutation(Variable[][] sets, int[][] initialPartialInstantiation, int[] permutation) {
        for (int i = 0; i < initialPartialInstantiation.length; ++i) {
            for (FunctionalPropagator propagator : this.costVarsPropagators) {
                propagator.propagate();
            }
        }
        long cost = this.solManager.solver.pb.optimizationPilot.value();
        if (cost < this.solManager.bestBound) {
            this.solManager.handleNewSolution(false);
        }
        return cost;
    }

    private void runTabuSearch(Variable[][] permutationSet, int[][] initialPartialInstantiation) {
        int[] permutation = Kit.range(permutationSet.length);
        boolean minimization = this.solManager.solver.pb.optimizationPilot.minimization;
        int tabuSize = 2 * permutationSet.length;
        int[] tabuIdxs = Kit.repeat(0, tabuSize);
        int[] tabuVals = Kit.repeat(-1, tabuSize);
        for (int i = 0; i < 100; ++i) {
            long bestCost = minimization ? Long.MAX_VALUE : Long.MIN_VALUE;
            int bestSwapIdx1 = -1;
            int bestSwapIdx2 = -1;
            for (int j = 0; j < permutation.length; ++j) {
                for (int k = j + 1; k < permutation.length; ++k) {
                    if (this.isTabu(permutation, tabuIdxs, tabuVals, j, k)) continue;
                    Kit.swap(permutation, j, k);
                    long currentCost = this.generateAndTestPermutation(permutationSet, initialPartialInstantiation, permutation);
                    if (minimization && currentCost < bestCost || !minimization && currentCost > bestCost) {
                        bestCost = currentCost;
                        bestSwapIdx1 = j;
                        bestSwapIdx2 = k;
                    }
                    Kit.swap(permutation, j, k);
                }
            }
            tabuIdxs[i * 2 % tabuSize] = bestSwapIdx1;
            tabuIdxs[(i * 2 + 1) % tabuSize] = bestSwapIdx2;
            tabuVals[i * 2 % tabuSize] = permutation[bestSwapIdx1];
            tabuVals[(i * 2 + 1) % tabuSize] = permutation[bestSwapIdx2];
            Kit.swap(permutation, bestSwapIdx1, bestSwapIdx2);
        }
    }

    private boolean isTabu(int[] permutation, int[] tabuIdxs, int[] tabuVals, int j, int k) {
        for (int i = 0; i < tabuIdxs.length; ++i) {
            if ((tabuIdxs[i] != j || tabuVals[i] != permutation[k]) && (tabuIdxs[i] != k || tabuVals[i] != permutation[j])) continue;
            return true;
        }
        return false;
    }
}

