/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.localBranching;

import objectives.OptimizationPilotDecreasing;
import search.Restarter;
import search.Solver;
import search.backtrack.SolverBacktrack;
import search.backtrack.localBranching.LocalBranchingConstraints;
import utility.Enums;
import utility.Kit;
import utility.interfaces.FilteringSpecific;

public final class RestarterLB
extends Restarter {
    private boolean currentlyBranching;
    private int nRestartsSinceActive = 0;
    private int currDistance;
    private LocalBranchingConstraints localBranchingConstraints;

    public RestarterLB(Solver solver) {
        super(solver);
        this.currDistance = this.solver.rs.cp.lb.baseDistance;
        this.localBranchingConstraints = this.solver.pb.localBranchingConstraints;
        Kit.control(solver instanceof SolverBacktrack, () -> "For local branching, only a SolverBacktrack can be used.");
        Kit.control(solver.pb.optimizationPilot instanceof OptimizationPilotDecreasing, () -> "For local branching, only OptimizationPilotDecreasing can be used.");
    }

    public void enterLocalBranching() {
        this.currentlyBranching = true;
        this.nRestartsSinceActive = 0;
    }

    private void leaveLocalBranching() {
        this.currentlyBranching = false;
        this.localBranchingConstraints.setIgnored(true);
        this.currDistance = this.solver.rs.cp.lb.baseDistance;
    }

    @Override
    public void beforeRun() {
        if (this.currentlyBranching) {
            ++this.nRestartsSinceActive;
        }
        super.beforeRun();
    }

    @Override
    public void afterRun() {
        if (this.currentlyBranching) {
            if (this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION || this.optimizationStop) {
                Kit.control(this.solver.pb.stuff.nValuesRemovedAtConstructionTime == 0, () -> "Not handled for the moment");
                if (this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION) {
                    this.solver.stoppingType = null;
                    ++this.currDistance;
                    if (this.solver.pb.optimizationPilot.areBoundsConsistent()) {
                        this.optimizationStop = true;
                    }
                }
                if (this.optimizationStop) {
                    super.afterRun();
                    this.currDistance = this.solver.rs.cp.lb.baseDistance;
                }
                this.localBranchingConstraints.updateWithNewSolution(this.solver.solManager.lastSolution, this.currDistance);
                this.localBranchingConstraints.setIgnored(false);
                ((SolverBacktrack)this.solver).restoreProblem();
                if (((SolverBacktrack)this.solver).learnerNogoods != null) {
                    ((SolverBacktrack)this.solver).learnerNogoods.reset();
                }
                ((FilteringSpecific)((Object)this.solver.pb.optimizationPilot.ctr)).runPropagator(null);
            }
            if (this.nRestartsSinceActive > this.solver.rs.cp.lb.maxRestarts) {
                this.leaveLocalBranching();
            }
        } else {
            super.afterRun();
        }
    }
}

