/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import executables.Resolution;
import search.backtrack.SolverBacktrack;
import search.backtrack.decomposers.Decomposer;
import search.backtrack.decomposers.Decomposer2;
import utility.Reflector;
import utility.interfaces.TagExperimental;
import variables.Variable;

public class DecomposerSolver
extends SolverBacktrack
implements TagExperimental {
    private int level = -1;
    private Decomposer[] decomposers;

    public int getLevel() {
        return this.level;
    }

    public Decomposer[] getDecomposers() {
        return this.decomposers;
    }

    public void setDomainsMarks(int level) {
        for (Variable x : this.pb.variables) {
            x.dom.setMark(level);
        }
    }

    public void restoreDomainsAtMarks(int level) {
        for (Variable x : this.pb.variables) {
            x.dom.restoreAtMark(level);
        }
    }

    public void pushVariable(Variable var) {
    }

    protected void restoreValuesStandardly(int previousDepth) {
        this.futVars.execute(x -> x.dom.restoreBefore(previousDepth));
    }

    @Override
    protected void manageEmptyDomainBeforeBacktracking() {
        ++this.backtrackStatistics.nBacktracks;
    }

    public DecomposerSolver(Resolution resolution) {
        super(resolution);
        int nbValues = Variable.nValidValuesFor(resolution.problem.variables);
        this.decomposers = new Decomposer[nbValues + 1];
    }

    private void branchingFor(Variable var) {
        ++this.level;
        if (this.decomposers[this.level] == null) {
            this.decomposers[this.level] = Reflector.buildObject(this.rs.cp.hardCoding.classForDecompositionSolver, Decomposer.class, this);
        }
        Decomposer decomposer = this.decomposers[this.level];
        decomposer.initialize(var);
        int idx = var.heuristicVal.bestValueIndex();
        assert (!(decomposer instanceof Decomposer2) || var.dom.size() == 1 || idx == ((Decomposer2)decomposer).getIndex());
        if (this.tryAssignment(var, idx)) {
            this.explore();
        }
        this.backtrack(var);
        if (!this.hasFinished() && !this.restarter.hasFinishedRun() && this.tryRefutation(var, idx)) {
            decomposer.split();
            if (decomposer.getNbPieces() == 1) {
                this.explore();
            } else {
                int res;
                this.setDomainsMarks(this.level);
                for (int num = 0; num < decomposer.getNbPieces() && (res = decomposer.buildPiece(num)) != -1; ++num) {
                    if (res == 1) {
                        this.explore();
                    }
                    if (num >= decomposer.getNbPieces() - 1) continue;
                    this.restoreDomainsAtMarks(this.level);
                }
            }
        }
        --this.level;
    }

    @Override
    public void explore() {
        if (this.futVars.size() == 0) {
            this.solManager.handleNewSolutionAndPossiblyOptimizeIt();
        } else if (!this.hasFinished() && !this.restarter.hasFinishedRun()) {
            this.branchingFor(this.heuristicVars.bestVar());
        }
    }
}

