/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.values.dynamic.Aic;
import java.util.Arrays;
import problem.Problem;
import propagation.soft.pfc.RDAC;
import search.backtrack.decomposers.Decomposer;
import search.backtrack.decomposers.DecomposerSolver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class Decomposer1
extends Decomposer {
    private int index;
    private int nbACNeighbors;
    private int[] idOfACNeighbors;
    private int[] nbConsistentValuesOfACNeighbors;
    private int[][] consistentValuesOfACNeighbors;
    private int nbPieces;
    private RDAC maxCSP;

    public Decomposer1(DecomposerSolver solver) {
        super(solver);
        Problem problem = solver.pb;
        this.idOfACNeighbors = new int[problem.stuff.maxVarDegree()];
        this.nbConsistentValuesOfACNeighbors = new int[problem.stuff.maxVarDegree()];
        this.consistentValuesOfACNeighbors = new int[problem.stuff.maxVarDegree()][this.nMaxValidTuples().intValueExact()];
        this.maxCSP = (RDAC)solver.propagation;
        Kit.control(problem.variables[0].heuristicVal instanceof Aic);
    }

    @Override
    public int getNbPieces() {
        return this.nbPieces;
    }

    @Override
    public void initialize(Variable var) {
        this.index = var.heuristicVal.bestValueIndex();
        this.maxCSP.init(false);
        assert (this.maxCSP.control());
        long[][][] minCosts = this.maxCSP.minCosts;
        assert (this.maxCSP.control());
        this.nbACNeighbors = 0;
        Constraint[] constraintArray = var.ctrs;
        int n = constraintArray.length;
        for (int i = 0; i < n; ++i) {
            int neighborPosition;
            Variable neighbor;
            Constraint ctr;
            int i2 = ctr.num;
            ctr = constraintArray[i];
            int j = ctr.positionOf(var);
            if (minCosts[i2][j][this.index] > 0L || (neighbor = ctr.scp[neighborPosition = j == 0 ? 1 : 0]).isAssigned()) continue;
            this.idOfACNeighbors[this.nbACNeighbors] = neighbor.num;
            int cnt = 0;
            int[] t = this.consistentValuesOfACNeighbors[this.nbACNeighbors];
            int[] tmp = ctr.tupleManager.localTuple;
            tmp[j] = this.index;
            Domain dom = neighbor.dom;
            int neighborIdx = dom.first();
            while (neighborIdx != -1) {
                tmp[neighborPosition] = neighborIdx;
                if (((CtrHard)ctr).checkIndexes(tmp)) {
                    t[cnt++] = neighborIdx;
                }
                neighborIdx = dom.next(neighborIdx);
            }
            this.nbConsistentValuesOfACNeighbors[this.nbACNeighbors] = cnt;
            ++this.nbACNeighbors;
        }
        this.nbPieces = this.nbACNeighbors;
    }

    @Override
    public void split() {
    }

    private boolean isSorted(int[] t, int limit) {
        for (int i = 1; i < limit; ++i) {
            if (t[i - 1] < t[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int buildPiece(int num) {
        int i;
        Domain dom;
        int[] t;
        int limit;
        Variable neighbor;
        Variable[] variables = this.solver.pb.variables;
        if (num > 0) {
            neighbor = variables[this.idOfACNeighbors[num - 1]];
            limit = this.nbConsistentValuesOfACNeighbors[num - 1];
            t = this.consistentValuesOfACNeighbors[num - 1];
            assert (this.isSorted(t, limit));
            dom = neighbor.dom;
            i = 0;
            int neighborIndex = dom.first();
            while (neighborIndex != -1) {
                while (i < limit && t[i] < neighborIndex) {
                    ++i;
                }
                assert ((i == limit || t[i] > neighborIndex) == Arrays.binarySearch(t, 0, limit, neighborIndex) < 0);
                if (i == limit || t[i] > neighborIndex) {
                    neighbor.dom.removeElementary(neighborIndex);
                }
                neighborIndex = dom.next(neighborIndex);
            }
            if (dom.size() == 0 || !this.maxCSP.go(false)) {
                return -1;
            }
            this.solver.setDomainsMarks(this.solver.getLevel());
        }
        neighbor = variables[this.idOfACNeighbors[num]];
        limit = this.nbConsistentValuesOfACNeighbors[num];
        t = this.consistentValuesOfACNeighbors[num];
        dom = neighbor.dom;
        for (i = 0; i < limit; ++i) {
            if (!dom.isPresent(t[i])) continue;
            dom.removeElementary(t[i]);
        }
        return dom.size() > 0 && this.maxCSP.go(false) ? 1 : 0;
    }
}

