/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import java.math.BigInteger;
import java.util.stream.Stream;
import search.backtrack.decomposers.DecomposerSolver;
import variables.Variable;

public abstract class Decomposer {
    protected DecomposerSolver solver;

    public Decomposer(DecomposerSolver solver) {
        this.solver = solver;
    }

    protected BigInteger nMaxValidTuples() {
        return Stream.of(this.solver.pb.constraints).map(c -> Variable.nValidTuples(c.scp, false)).max(BigInteger::compareTo).get();
    }

    public abstract int getNbPieces();

    public abstract void initialize(Variable var1);

    public abstract void split();

    public abstract int buildPiece(int var1);
}

