/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import constraints.Constraint;
import executables.Resolution;
import heuristics.values.dynamic.Failures;
import heuristics.variables.HeuristicVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import learning.LearnerNogoods;
import learning.LearnerNogoodsAdvanced;
import learning.LearnerStates;
import learning.LearnerStatesDominance;
import learning.LearnerStatesEquivalence;
import propagation.order1.AC;
import propagation.order1.PropagationForward;
import propagation.order1.inverse.GIC2;
import search.Solver;
import search.backtrack.DecisionRecorder;
import search.backtrack.GlobalObserver;
import search.backtrack.LastConflictReasoner;
import search.statistics.Statistics;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.observers.ObserverBacktrackingSystematic;
import utility.observers.ObserverBacktrackingUnsystematic;
import utility.observers.ObserverRuns;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public class SolverBacktrack
extends Solver
implements ObserverRuns,
ObserverBacktrackingSystematic {
    public int minDepth;
    public int maxDepth;
    public final DecisionRecorder dr;
    public HeuristicVariables heuristicVars;
    public final LastConflictReasoner lcReasoner;
    public final LearnerNogoods learnerNogoods;
    public final LearnerStates learnerStates;
    public final Proofer proofer;
    public final GlobalObserver observerVars;
    public final GlobalObserver observerCtrsSoft;
    public final List<ObserverBacktrackingSystematic> observersBacktrackingSystematic;
    public final Tracer tracer;
    public Statistics.StatisticsBacktrack backtrackStatistics;
    private final Variable[] lastPastBeforeRun = new Variable[2];
    private int nRecursiveRuns = 0;
    public MinimalNogoodExtractor minimalNogoodExtractor;

    @Override
    public void beforeRun() {
        this.minDepth = this.pb.variables.length + 1;
        this.maxDepth = 0;
    }

    @Override
    public void afterRun() {
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.observerVars.restoreAtDepthBefore(depthBeforeBacktrack);
        this.observerCtrsSoft.restoreAtDepthBefore(depthBeforeBacktrack);
    }

    @Override
    public final void pushVariable(ObserverBacktrackingUnsystematic x) {
        this.observerVars.push(x);
    }

    private List<ObserverBacktrackingSystematic> collectObserversBacktrackingSystematic() {
        ArrayList<ObserverBacktrackingSystematic> list = new ArrayList<ObserverBacktrackingSystematic>();
        list.add(this);
        Stream.of(this.pb.constraints).filter(c -> c instanceof ObserverBacktrackingSystematic).forEach(c -> list.add((ObserverBacktrackingSystematic)((Object)c)));
        if (this.propagation instanceof ObserverBacktrackingSystematic) {
            list.add((ObserverBacktrackingSystematic)((Object)this.propagation));
        }
        return list;
    }

    protected List<ObserverRuns> collectObserversRuns() {
        ArrayList<ObserverRuns> list = new ArrayList<ObserverRuns>();
        Stream.of(this, this.restarter, this.learnerNogoods, this.learnerStates, this.heuristicVars, this.lcReasoner, this.stats).filter(o -> o instanceof ObserverRuns).forEach(o -> list.add((ObserverRuns)o));
        Stream.of(this.pb.constraints).filter(c -> c instanceof ObserverRuns).forEach(c -> list.add((ObserverRuns)((Object)c)));
        if (this.propagation instanceof ObserverRuns) {
            list.add((ObserverRuns)((Object)this.propagation));
        }
        return list;
    }

    @Override
    public void reset() {
        super.reset();
        this.dr.reset();
        this.heuristicVars.setPriorityVars(this.pb.priorityVars, 0);
        this.lcReasoner.beforeRun();
        if (this.learnerNogoods != null) {
            this.learnerNogoods.reset();
        }
        Kit.control(this.learnerStates == null);
        Kit.control(this.observerVars.top == -1, () -> "Top= " + this.observerVars.top);
        Kit.control(this.observerCtrsSoft.top == -1);
        this.backtrackStatistics = new Statistics.StatisticsBacktrack(this);
        this.stats = this.backtrackStatistics;
        Kit.control(!this.proofer.active);
    }

    public SolverBacktrack(Resolution resolution) {
        super(resolution);
        this.dr = new DecisionRecorder(this);
        this.heuristicVars = resolution.cp.solving.enableSearch || this.propagation instanceof GIC2 ? Reflector.buildObject(resolution.cp.varh.classForVarHeuristic, HeuristicVariables.class, this, resolution.cp.varh.anti) : null;
        this.lcReasoner = new LastConflictReasoner(this, resolution.cp.varh.lastConflictSize);
        if (this.heuristicVars != null) {
            Stream.of(this.pb.variables).forEach(x -> x.buildValueOrderingHeuristic());
        }
        LearnerNogoods learnerNogoods = this.learnerNogoods = resolution.cp.solving.enableSearch && resolution.cp.learning.nogood != Enums.ELearningNogood.NO && this.propagation.queue != null ? new LearnerNogoodsAdvanced(this) : null;
        this.learnerStates = resolution.cp.learning.state == Enums.ELearningState.EQUIVALENCE ? new LearnerStatesEquivalence(this) : (resolution.cp.learning.state == Enums.ELearningState.DOMINANCE ? new LearnerStatesDominance(this) : null);
        this.proofer = new Proofer(this.learnerStates);
        int nLevels = this.pb.variables.length + 1;
        int size = Stream.of(this.pb.variables).mapToInt(x -> x.dom.initSize()).reduce(0, (sum, domSize) -> sum + Math.min(nLevels, domSize));
        this.observerVars = new GlobalObserver(this, size + nLevels);
        this.observerCtrsSoft = new GlobalObserver(this, resolution.cp.optimizing.costTranfer != Enums.ECostTranfer.INVARIABLE ? this.pb.constraints.length * nLevels + nLevels : 0);
        this.observersBacktrackingSystematic = this.collectObserversBacktrackingSystematic();
        this.observersRuns = this.collectObserversRuns();
        this.tracer = new Tracer(resolution.cp.general.trace);
        this.backtrackStatistics = new Statistics.StatisticsBacktrack(this);
        this.stats = this.backtrackStatistics;
        this.minimalNogoodExtractor = new MinimalNogoodExtractor();
    }

    @Override
    public int depth() {
        return this.futVars.nDiscarded();
    }

    @Override
    public void assign(Variable x, int a) {
        assert (!x.isAssigned());
        this.reduceWithUniversalValues();
        ++this.backtrackStatistics.nAssignments;
        this.futVars.assign(x);
        x.doAssignment(a);
        this.dr.addPositiveDecision(x, a);
        this.rs.observerRemote.onAssigned(x, a);
    }

    @Override
    public final void backtrack(Variable x) {
        this.futVars.unassign(x);
        x.undoAssignment();
        this.dr.delPositiveDecision(x);
        int depthBeforeBacktrack = this.depth() + 1;
        for (ObserverBacktrackingSystematic obs : this.observersBacktrackingSystematic) {
            obs.restoreAtDepthBefore(depthBeforeBacktrack);
        }
        if (this.propagation instanceof PropagationForward) {
            this.propagation.queue.clear();
        }
        this.rs.observerRemote.onBacktrack();
    }

    @Override
    public final void backtrack() {
        this.backtrack(this.futVars.lastPast());
    }

    protected void manageEmptyDomainBeforeBacktracking() {
        this.tracer.prnBacktrack();
        ++this.backtrackStatistics.nBacktracks;
        if (this.learnerStates != null) {
            this.learnerStates.dealWhenClosingNode();
        }
        if (this.futVars.nDiscarded() == 0) {
            this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
    }

    public final boolean tryAssignment(Variable x, int a) {
        boolean consistent;
        ++this.stats.nVisitedNodes;
        if (x.dom.size() > 1) {
            ++this.stats.nDecisions;
        }
        this.tracer.prnAssignment(x, a);
        this.maxDepth = Math.max(this.maxDepth, this.depth());
        this.lcReasoner.doWhenAssignment(x);
        this.assign(x, a);
        this.proofer.reset();
        boolean bl = consistent = this.propagation.runAfterAssignment(x) && (this.learnerStates == null || this.learnerStates.dealWhenOpeningNode());
        if (x.heuristicVal instanceof Failures) {
            ((Failures)x.heuristicVal).updateWith(a, this.depth(), consistent);
        }
        if (!consistent) {
            ++this.stats.nWrongDecisions;
            ++this.backtrackStatistics.nFailedAssignments;
            if (this.learnerNogoods != null) {
                this.learnerNogoods.addCurrentNogood();
            }
            return false;
        }
        return true;
    }

    public final boolean tryAssignment(Variable x) {
        return this.tryAssignment(x, x.heuristicVal.bestValueIndex());
    }

    protected final boolean tryRefutation(Variable x, int a) {
        boolean consistent;
        this.tracer.prnRefutation(x, a);
        this.minDepth = Math.min(this.minDepth, this.depth());
        this.lcReasoner.doWhenRefutation(x, a);
        this.dr.addNegativeDecision(x, a);
        this.proofer.recopy();
        x.dom.removeElementary(a);
        boolean bl = consistent = x.dom.size() > 0;
        if (consistent) {
            if (this.rs.cp.solving.branching == Enums.EBranching.NON) {
                return true;
            }
            ++this.stats.nVisitedNodes;
            ++this.stats.nDecisions;
            consistent = this.propagation.runAfterRefutation(x);
            if (!consistent) {
                ++this.stats.nWrongDecisions;
            }
        }
        if (!consistent) {
            this.manageEmptyDomainBeforeBacktracking();
        }
        return consistent;
    }

    private void manageContradiction() {
        boolean consistent = false;
        while (!consistent && this.stoppingType != Enums.EStopping.FULL_EXPLORATION) {
            Variable x = this.futVars.lastPast();
            if (x == this.lastPastBeforeRun[this.nRecursiveRuns - 1] && !this.rs.cp.lns.enabled) {
                this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
                continue;
            }
            int a = x.dom.unique();
            this.backtrack(x);
            consistent = this.tryRefutation(x, a);
        }
    }

    public void explore() {
        while (!this.hasFinished() && !this.restarter.hasFinishedRun()) {
            while (this.futVars.size() != 0 && !this.hasFinished() && !this.restarter.hasFinishedRun()) {
                if (this.tryAssignment(this.heuristicVars.bestVar())) continue;
                this.manageContradiction();
            }
            if (this.futVars.size() != 0) continue;
            this.solManager.handleNewSolutionAndPossiblyOptimizeIt();
            if (this.hasFinished() || this.restarter.hasFinishedRun()) continue;
            this.manageContradiction();
        }
        if (this.learnerNogoods != null && !this.hasFinished() && !this.restarter.areAllRunsFinished()) {
            this.learnerNogoods.addNogoodsOfCurrentBranch();
        }
    }

    @Override
    public final Solver doRun() {
        this.lastPastBeforeRun[this.nRecursiveRuns++] = this.futVars.lastPast();
        this.explore();
        this.backtrackTo(this.lastPastBeforeRun[--this.nRecursiveRuns]);
        return this;
    }

    private void backtrackTo(Variable x) {
        assert (x == null || x.isAssigned());
        while (this.futVars.lastPast() != x) {
            this.backtrack(this.futVars.lastPast());
        }
    }

    public void backtrackToTheRoot() {
        this.backtrackTo(null);
    }

    public final void restoreProblem() {
        this.backtrackToTheRoot();
        this.observerVars.restoreAtDepthBefore(0);
        this.observerCtrsSoft.restoreAtDepthBefore(0);
        this.observersBacktrackingSystematic.stream().forEach(obs -> obs.restoreAtDepthBefore(0));
        this.dr.reset();
        assert (Stream.of(this.pb.variables).allMatch(x -> x.dom.controlStructures()));
    }

    @Override
    public final void solve() {
        super.solve();
        this.restoreProblem();
    }

    private void reduceWithUniversalValues() {
        boolean test = false;
        if (test) {
            for (Variable var : this.pb.variables) {
                Domain dom = var.dom;
                if (dom.size() == 1) continue;
                int idx = dom.first();
                while (idx != -1) {
                    boolean universal = true;
                    for (Constraint ctr : var.ctrs) {
                        boolean found = false;
                        for (Variable v : ctr.scp) {
                            if (v == var || v.dom.isPresent(idx)) continue;
                            found = true;
                        }
                        if (found) continue;
                        universal = false;
                        break;
                    }
                    if (universal) {
                        var.dom.reduceTo(idx);
                    }
                    idx = dom.next(idx);
                }
            }
        }
    }

    public int doGreedy(int[] vids, int[] idxs, int limit) {
        int i;
        int max = limit;
        Variable[] variables = this.pb.variables;
        for (i = 0; i <= max && variables[vids[i]].dom.isPresent(idxs[i]); ++i) {
            this.assign(variables[vids[i]], idxs[i]);
            if (!this.propagation.runAfterAssignment(variables[vids[i]])) break;
        }
        if (i > limit) {
            --i;
        }
        this.backtrackToTheRoot();
        return i;
    }

    public class MinimalNogoodExtractor {
        private boolean addPositiveTransitionDecisionTo(int positiveDecision, int[] tmp, int nbFoundTransitionDecisions) {
            tmp[nbFoundTransitionDecisions] = positiveDecision;
            Variable var = SolverBacktrack.this.dr.varIn(positiveDecision);
            int idx = SolverBacktrack.this.dr.idxIn(positiveDecision);
            if (!var.dom.isPresent(idx)) {
                return false;
            }
            SolverBacktrack.this.assign(var, idx);
            return SolverBacktrack.this.propagation.runAfterAssignment(var);
        }

        private int searchPositiveTransitionDecision(int right, int[] decs, int limitDepth) {
            int left;
            boolean consistent = true;
            for (left = 0; consistent && left < right; ++left) {
                Variable var = SolverBacktrack.this.dr.varIn(decs[left]);
                int idx = SolverBacktrack.this.dr.idxIn(decs[left]);
                if (!var.dom.isPresent(idx)) {
                    consistent = false;
                } else {
                    SolverBacktrack.this.assign(var, idx);
                    consistent = SolverBacktrack.this.propagation.runAfterAssignment(var);
                }
                assert (!consistent || !(SolverBacktrack.this.propagation instanceof AC) || ((AC)SolverBacktrack.this.propagation).controlArcConsistency());
            }
            if (consistent) {
                return -1;
            }
            while (SolverBacktrack.this.futVars.size() > 0 && SolverBacktrack.this.depth() != limitDepth - 1) {
                SolverBacktrack.this.backtrack();
            }
            return left - 1;
        }

        public int[] extractMinimalNogoodFrom(int[] decs) {
            boolean backgroundConsistent;
            int[] tmp = new int[decs.length];
            int positionOfLastFoundTransitionDecision = decs.length - 1;
            int nbFoundTransitionDecisions = 0;
            if (!(backgroundConsistent = this.addPositiveTransitionDecisionTo(decs[positionOfLastFoundTransitionDecision], tmp, nbFoundTransitionDecisions++))) {
                Variable x = SolverBacktrack.this.futVars.lastPast();
                int a = x.dom.unique();
                SolverBacktrack.this.backtrack(x);
                x.dom.removeElementary(a);
                boolean bl = backgroundConsistent = x.dom.size() > 0 && SolverBacktrack.this.propagation.runAfterRefutation(x);
                if (!backgroundConsistent) {
                    SolverBacktrack.this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
                    return new int[0];
                }
                return null;
            }
            while (backgroundConsistent && 0 < positionOfLastFoundTransitionDecision && nbFoundTransitionDecisions < SolverBacktrack.this.rs.cp.learning.nogoodArityLimit) {
                if (positionOfLastFoundTransitionDecision == 1) {
                    tmp[nbFoundTransitionDecisions++] = decs[0];
                    break;
                }
                if ((positionOfLastFoundTransitionDecision = this.searchPositiveTransitionDecision(positionOfLastFoundTransitionDecision, decs, SolverBacktrack.this.depth())) == -1) continue;
                backgroundConsistent = this.addPositiveTransitionDecisionTo(decs[positionOfLastFoundTransitionDecision], tmp, nbFoundTransitionDecisions++);
            }
            SolverBacktrack.this.backtrackToTheRoot();
            if (positionOfLastFoundTransitionDecision == -1) {
                int[] t = new int[decs.length];
                for (int i = 0; i < t.length; ++i) {
                    t[i] = -decs[i];
                }
                return t;
            }
            int[] t = new int[nbFoundTransitionDecisions];
            for (int i = 0; i < t.length; ++i) {
                t[i] = -tmp[i];
            }
            return t;
        }

        private boolean addTransitionDecisionTo(int indexOfLastTransitionDecision, int[] tmp, int nbFoundTransitionDecisions, int[] decs, int nbDecs) {
            tmp[nbFoundTransitionDecisions] = decs[indexOfLastTransitionDecision];
            int limit = Math.max(0, nbFoundTransitionDecisions - 1);
            while (tmp[limit] < 0) {
                --limit;
            }
            for (int i = limit; i < nbFoundTransitionDecisions; ++i) {
                boolean consistent;
                Variable var = SolverBacktrack.this.dr.varIn(tmp[i]);
                int idx = SolverBacktrack.this.dr.idxIn(tmp[i]);
                if (tmp[i] > 0) {
                    assert (var.dom.isPresent(idx));
                    SolverBacktrack.this.assign(var, idx);
                    consistent = SolverBacktrack.this.propagation.runAfterAssignment(var);
                    assert (consistent);
                    continue;
                }
                assert (var.dom.size() > 1 || !var.dom.isPresent(idx));
                if (!var.dom.isPresent(idx)) continue;
                var.dom.removeElementary(idx);
                boolean bl = consistent = var.dom.size() > 0 && SolverBacktrack.this.propagation.runAfterRefutation(var);
                assert (consistent);
            }
            Variable var = SolverBacktrack.this.dr.varIn(decs[indexOfLastTransitionDecision]);
            int idx = SolverBacktrack.this.dr.idxIn(decs[indexOfLastTransitionDecision]);
            boolean consistent = true;
            if (decs[indexOfLastTransitionDecision] > 0) {
                if (!var.dom.isPresent(idx)) {
                    return false;
                }
                SolverBacktrack.this.assign(var, idx);
                consistent = SolverBacktrack.this.propagation.runAfterAssignment(var);
            } else {
                if (var.dom.size() == 1 && var.dom.isPresent(idx)) {
                    return false;
                }
                if (var.dom.isPresent(idx)) {
                    var.dom.removeElementary(idx);
                    consistent = var.dom.size() > 0 && SolverBacktrack.this.propagation.runAfterRefutation(var);
                }
            }
            return consistent;
        }

        private int searchTransitionDecision(int left, int right, int[] decs, int nbDecs, int limitDepth) {
            boolean consistent = true;
            while (left < right && consistent) {
                Variable x = SolverBacktrack.this.dr.varIn(decs[left]);
                int a = SolverBacktrack.this.dr.idxIn(decs[left]);
                if (decs[left] > 0) {
                    if (!x.dom.isPresent(a)) {
                        consistent = false;
                    } else {
                        SolverBacktrack.this.assign(x, a);
                        consistent = SolverBacktrack.this.propagation.runAfterAssignment(x);
                    }
                } else if (x.dom.size() == 1 && x.dom.isPresent(a)) {
                    consistent = false;
                } else if (x.dom.isPresent(a)) {
                    x.dom.removeElementary(a);
                    boolean bl = consistent = x.dom.size() > 0 && SolverBacktrack.this.propagation.runAfterRefutation(x);
                }
                assert (!consistent || !(SolverBacktrack.this.propagation instanceof AC) || ((AC)SolverBacktrack.this.propagation).controlArcConsistency());
                ++left;
            }
            if (left == nbDecs - 1 && consistent) {
                return -1;
            }
            assert (!consistent && left - 1 < right) : "cons = " + consistent + " lastPositive = " + (left - 1);
            while (SolverBacktrack.this.futVars.size() > 0 && SolverBacktrack.this.depth() != limitDepth - 1) {
                SolverBacktrack.this.backtrack();
            }
            return left - 1;
        }

        public int[] extractMinimalNogoodFrom(SolverBacktrack solver, int[] decs, int nbDecs) {
            SolverBacktrack.this.propagation.queue.clear();
            Variable[] variables = SolverBacktrack.this.pb.variables;
            for (int i = 0; i < variables.length; ++i) {
                Domain dom = solver.pb.variables[i].dom;
                int a = dom.lastRemoved();
                while (a != -1) {
                    if (dom.isRemovedAtLevel(a, 0)) {
                        variables[i].dom.remove(a, 0);
                    }
                    a = dom.prevRemoved(a);
                }
            }
            int[] tmp = new int[nbDecs];
            int nbFoundTransitionDecisions = 0;
            boolean consistent = this.addTransitionDecisionTo(nbDecs - 1, tmp, nbFoundTransitionDecisions++, decs, nbDecs);
            int initialLeftOffset = 0;
            while (decs[initialLeftOffset] < 0) {
                ++initialLeftOffset;
            }
            int right = nbDecs - 1;
            while (consistent && nbFoundTransitionDecisions < SolverBacktrack.this.rs.cp.learning.nogoodArityLimit && initialLeftOffset < right) {
                assert (decs[initialLeftOffset] > 0);
                int IndexOfTransitionDecision = this.searchTransitionDecision(initialLeftOffset, right, decs, nbDecs, SolverBacktrack.this.depth());
                if (IndexOfTransitionDecision == -1) {
                    right = -1;
                    continue;
                }
                right = IndexOfTransitionDecision;
                consistent = this.addTransitionDecisionTo(IndexOfTransitionDecision, tmp, nbFoundTransitionDecisions++, decs, nbDecs);
            }
            SolverBacktrack.this.restoreProblem();
            if (consistent && nbFoundTransitionDecisions >= SolverBacktrack.this.rs.cp.learning.nogoodArityLimit || right == -1 && nbDecs >= SolverBacktrack.this.rs.cp.learning.nogoodArityLimit) {
                return null;
            }
            int[] nogood = null;
            if (right == -1) {
                int nbPositiveDecisions = 0;
                for (int i = 0; i < nbDecs; ++i) {
                    if (decs[i] <= 0) continue;
                    ++nbPositiveDecisions;
                }
                nogood = new int[nbPositiveDecisions + 2];
                int cnt = 2;
                for (int i = 0; i < nbDecs; ++i) {
                    if (decs[i] <= 0) continue;
                    nogood[cnt++] = -decs[i];
                }
            } else {
                nogood = new int[nbFoundTransitionDecisions + 2];
                for (int i = 2; i < nogood.length; ++i) {
                    nogood[i] = -tmp[i - 2];
                }
            }
            assert (this.controlMinimalNogood(solver, nogood));
            return nogood;
        }

        public int[] extractMinimalNogoodFrom(SolverBacktrack solver, SetDense denseSet) {
            return this.extractMinimalNogoodFrom(solver, denseSet.dense, denseSet.size());
        }

        public boolean controlMinimalNogood(SolverBacktrack solver, int[] t) {
            if (t == null) {
                return true;
            }
            SolverBacktrack.this.propagation.queue.clear();
            for (int i = 0; i < SolverBacktrack.this.pb.variables.length; ++i) {
                Domain dom = solver.pb.variables[i].dom;
                Domain auxiliaryDom = SolverBacktrack.this.pb.variables[i].dom;
                int a = dom.lastRemoved();
                while (a != -1) {
                    if (dom.isRemovedAtLevel(a, 0)) {
                        auxiliaryDom.remove(a, 0);
                    }
                    a = dom.prevRemoved(a);
                }
            }
            boolean notMinimal = false;
            for (int i = 2; !notMinimal && i < t.length; ++i) {
                boolean consistent;
                int decision = -t[i];
                Variable var = SolverBacktrack.this.dr.varIn(decision);
                int idx = SolverBacktrack.this.dr.idxIn(decision);
                if (decision > 0) {
                    if (!var.dom.isPresent(idx)) {
                        if (i == t.length - 1) continue;
                        Kit.log.info("nogood not minimal 1 " + var + " " + idx);
                        notMinimal = true;
                        continue;
                    }
                    SolverBacktrack.this.assign(var, idx);
                    consistent = SolverBacktrack.this.propagation.runAfterAssignment(var);
                    if (consistent || i == t.length - 1) continue;
                    Kit.log.info("nogood not minimal 2 " + var + " " + idx);
                    notMinimal = true;
                    continue;
                }
                if (var.dom.size() == 1 && var.dom.isPresent(idx)) {
                    if (i == t.length - 1) continue;
                    Kit.log.info("nogood not minimal 3 " + var + " " + idx);
                    notMinimal = true;
                    continue;
                }
                if (!var.dom.isPresent(idx)) continue;
                var.dom.removeElementary(idx);
                boolean bl = consistent = var.dom.size() > 0 && SolverBacktrack.this.propagation.runAfterRefutation(var);
                if (consistent || i == t.length - 1) continue;
                Kit.log.info("nogood not minimal 4 " + var + " " + idx);
                notMinimal = true;
            }
            SolverBacktrack.this.restoreProblem();
            return !notMinimal;
        }
    }

    public final class Proofer {
        private final boolean active;
        private final boolean[][] proofVariables;

        public Proofer(LearnerStates learner) {
            this.active = learner != null && SolverBacktrack.this.learnerStates.reductionOperator.enablePElimination();
            this.proofVariables = this.active ? new boolean[SolverBacktrack.this.pb.variables.length + 1][SolverBacktrack.this.pb.variables.length] : (boolean[][])null;
        }

        public boolean[] getProofVariablesAt(int depth) {
            return this.proofVariables[depth];
        }

        public void updateProof(Constraint c) {
            if (this.active) {
                for (Variable x : c.scp) {
                    this.proofVariables[SolverBacktrack.this.depth()][x.num] = true;
                }
            }
        }

        public void updateProof(int[] varNums) {
            if (this.active) {
                for (int num : varNums) {
                    this.proofVariables[SolverBacktrack.this.depth()][num] = true;
                }
            }
        }

        public void updateProofAll() {
            if (this.active) {
                Arrays.fill(this.proofVariables[SolverBacktrack.this.depth()], true);
            }
        }

        public void reset() {
            if (this.active) {
                Arrays.fill(this.proofVariables[SolverBacktrack.this.depth()], false);
            }
        }

        public void recopy() {
            if (this.active) {
                int d = SolverBacktrack.this.depth();
                for (int i = SolverBacktrack.this.pb.variables.length - 1; i >= 0; --i) {
                    if (!this.proofVariables[d + 1][i]) continue;
                    this.proofVariables[d][i] = true;
                }
            }
        }
    }

    public class Tracer {
        private boolean active;
        private int minDepthLimit;
        private int maxDepthLimit;

        private Tracer(String s) {
            this.active = s.length() != 0;
            StringTokenizer st = this.active && s.contains("-") ? new StringTokenizer(s, "-") : null;
            this.minDepthLimit = st != null && st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : Integer.MIN_VALUE;
            this.maxDepthLimit = st != null && st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : Integer.MAX_VALUE;
        }

        public void prnBacktrack() {
            if (this.active && !SolverBacktrack.this.propagation.performingProperSearch && this.minDepthLimit <= SolverBacktrack.this.depth() && SolverBacktrack.this.depth() <= this.maxDepthLimit) {
                Kit.log.fine("        Backtrack ");
            }
        }

        public void prnAssignment(Variable x, int a) {
            if (this.active && !SolverBacktrack.this.propagation.performingProperSearch && this.minDepthLimit <= SolverBacktrack.this.depth() && SolverBacktrack.this.depth() <= this.maxDepthLimit) {
                Kit.log.fine("At " + SolverBacktrack.this.depth() + ", " + x + " = " + a + (x.dom.indexesMatchValues() ? "" : "(" + x.dom.toVal(a) + ") ") + (x.dom.size() == 1 ? " singleton" : ""));
            }
        }

        public void prnRefutation(Variable x, int a) {
            if (this.active && !SolverBacktrack.this.propagation.performingProperSearch && this.minDepthLimit <= SolverBacktrack.this.depth() && SolverBacktrack.this.depth() <= this.maxDepthLimit) {
                Kit.log.fine("At " + SolverBacktrack.this.depth() + ", " + x + " != " + a);
            }
        }
    }
}

