/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import search.backtrack.SolverBacktrack;
import search.statistics.Statistics;
import utility.Kit;
import utility.observers.ObserverRuns;
import variables.Variable;

public final class LastConflictReasoner
implements ObserverRuns {
    private SolverBacktrack solver;
    private boolean active;
    private int nCurrLastReasoningVariables;
    private Variable lastAssignedVariable;
    private Variable candidateForLastReasoning;
    private Variable[] lastReasoningVariables;
    private int startLevelForStatistics;
    private int[] sizesStatistics;
    private int[] levelsStatistics;

    @Override
    public void beforeRun() {
        this.nCurrLastReasoningVariables = 0;
        this.candidateForLastReasoning = null;
    }

    @Override
    public void afterRun() {
        this.displayStatistics();
    }

    public void setMode(int raisonningExtent) {
        if (raisonningExtent > 0) {
            this.active = true;
            this.lastReasoningVariables = new Variable[raisonningExtent];
            this.sizesStatistics = new int[raisonningExtent + 1];
            this.levelsStatistics = new int[raisonningExtent + 1];
        } else {
            this.active = false;
        }
        this.beforeRun();
    }

    public LastConflictReasoner(SolverBacktrack solver, int raisonningExtent) {
        this.solver = solver;
        this.setMode(raisonningExtent);
    }

    public Variable lastConflictPriorityVar() {
        if (!this.active) {
            return null;
        }
        if (this.nCurrLastReasoningVariables == 0) {
            if (this.lastAssignedVariable == null || this.lastAssignedVariable.isAssigned()) {
                return null;
            }
            this.startLevelForStatistics = this.solver.depth() + 1;
            this.lastReasoningVariables[this.nCurrLastReasoningVariables++] = this.lastAssignedVariable;
            return this.lastAssignedVariable;
        }
        for (int i = 0; i < this.nCurrLastReasoningVariables; ++i) {
            if (this.lastReasoningVariables[i].isAssigned()) continue;
            return this.lastReasoningVariables[i];
        }
        if (this.nCurrLastReasoningVariables == this.lastReasoningVariables.length || this.candidateForLastReasoning == null || this.candidateForLastReasoning.isAssigned()) {
            this.updateStatistics(this.nCurrLastReasoningVariables);
            this.nCurrLastReasoningVariables = 0;
            this.candidateForLastReasoning = null;
            return null;
        }
        this.lastReasoningVariables[this.nCurrLastReasoningVariables++] = this.candidateForLastReasoning;
        this.candidateForLastReasoning = null;
        return this.lastReasoningVariables[this.nCurrLastReasoningVariables - 1];
    }

    public final void doWhenAssignment(Variable x) {
        if (!this.active) {
            return;
        }
        if (this.nCurrLastReasoningVariables == 0) {
            this.lastAssignedVariable = x;
        }
    }

    public void doWhenRefutation(Variable x, int a) {
        if (!this.active) {
            return;
        }
        if (this.nCurrLastReasoningVariables == 0) {
            if (x != this.lastAssignedVariable) {
                this.candidateForLastReasoning = x;
            }
        } else if (this.nCurrLastReasoningVariables < this.lastReasoningVariables.length) {
            for (int i = 0; i < this.nCurrLastReasoningVariables; ++i) {
                if (this.lastReasoningVariables[i] != x) continue;
                return;
            }
            this.candidateForLastReasoning = x;
        }
    }

    private void updateStatistics(int offset) {
        int n = this.nCurrLastReasoningVariables;
        this.sizesStatistics[n] = this.sizesStatistics[n] + 1;
        int n2 = this.nCurrLastReasoningVariables;
        this.levelsStatistics[n2] = this.levelsStatistics[n2] + (this.startLevelForStatistics - this.solver.depth() + offset);
    }

    public void displayStatistics() {
        if (this.active) {
            if (this.nCurrLastReasoningVariables > 0) {
                this.updateStatistics(0);
            }
            String s = IntStream.range(1, this.sizesStatistics.length).mapToObj(i -> i + ":(#=" + this.sizesStatistics[i] + (this.sizesStatistics[i] == 0 ? "" : ",avg=" + Statistics.decimalFormat.format((double)this.levelsStatistics[i] / (double)this.sizesStatistics[i]))).collect(Collectors.joining(")  "));
            Kit.log.info("last-conflicts  " + s + ")\n");
        }
    }
}

