/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.LNS.heuristics;

import search.backtrack.LNS.RestarterLNS;
import search.backtrack.LNS.heuristics.HeuristicFreezing;
import search.backtrack.SolverBacktrack;
import variables.Variable;

public class Impact
extends HeuristicFreezing {
    private final Variable[] variables;
    private int[] domainSizesBeforeFreezing;
    private int[] domainSizesAfterFreezing;

    public Impact(RestarterLNS restarter) {
        super(restarter);
        this.variables = restarter.solver.pb.variables;
        this.domainSizesBeforeFreezing = new int[this.variables.length];
        this.domainSizesAfterFreezing = new int[this.variables.length];
    }

    private void storeDomainSizes(int[] t) {
        for (int i = 0; i < this.variables.length; ++i) {
            t[i] = this.variables[i].dom.size();
        }
    }

    @Override
    public void freezeVariables(int[] solution) {
        this.shuffle();
        Integer bestImpacted = null;
        for (int i = 0; i < this.freezingSize; ++i) {
            if (bestImpacted != null) {
                int tmp = this.freezingShuffled[bestImpacted];
                this.freezingShuffled[bestImpacted.intValue()] = this.freezingShuffled[i];
                this.freezingShuffled[i] = tmp;
            }
            this.restarter.solver.assign(this.variables[this.freezingShuffled[i]], solution[this.freezingShuffled[i]]);
            this.storeDomainSizes(this.domainSizesBeforeFreezing);
            this.restarter.solver.propagation.runInitially();
            this.storeDomainSizes(this.domainSizesAfterFreezing);
            bestImpacted = null;
            int bestImpact = 0;
            for (int j = i + 1; j < this.freezingShuffled.length; ++j) {
                int impact = this.domainSizesBeforeFreezing[this.freezingShuffled[j]] - this.domainSizesAfterFreezing[this.freezingShuffled[j]];
                if (impact <= bestImpact) continue;
                bestImpacted = j;
                bestImpact = impact;
            }
        }
        ((SolverBacktrack)this.restarter.solver).backtrackToTheRoot();
    }
}

