/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.LNS.heuristics;

import java.util.Random;
import java.util.stream.IntStream;
import search.backtrack.LNS.RestarterLNS;
import utility.Kit;

public abstract class HeuristicFreezing {
    protected final RestarterLNS restarter;
    public final int[] freezingShuffled;
    public int freezingSize;

    public HeuristicFreezing(RestarterLNS restarter) {
        this.restarter = restarter;
        this.freezingShuffled = IntStream.range(0, restarter.solver.pb.variables.length).toArray();
        if (0 < restarter.solver.rs.cp.lns.nVariablesToFreeze && restarter.solver.rs.cp.lns.nVariablesToFreeze < restarter.solver.pb.variables.length) {
            this.freezingSize = restarter.solver.rs.cp.lns.nVariablesToFreeze;
        } else if (0 < restarter.solver.rs.cp.lns.pVariablesToFreeze && restarter.solver.rs.cp.lns.pVariablesToFreeze < 100) {
            this.freezingSize = 1 + restarter.solver.rs.cp.lns.pVariablesToFreeze * restarter.solver.pb.variables.length / 100;
        } else {
            Kit.exit("You must specify the number or percentage of variables to freeze for LNS.");
        }
        Kit.control(0 < this.freezingSize && this.freezingSize < restarter.solver.pb.variables.length, () -> "");
    }

    protected void shuffle() {
        Random random = this.restarter.solver.rs.random;
        for (int i = this.freezingShuffled.length - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            int tmp = this.freezingShuffled[i];
            this.freezingShuffled[i] = this.freezingShuffled[j];
            this.freezingShuffled[j] = tmp;
        }
    }

    public abstract void freezeVariables(int[] var1);
}

