/*
 * Decompiled with CFR 0.152.
 */
package search;

import executables.Resolution;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import problem.Problem;
import propagation.Propagation;
import search.FutureVariables;
import search.Restarter;
import search.SolutionManager;
import search.backtrack.LNS.RestarterLNS;
import search.backtrack.localBranching.RestarterLB;
import search.statistics.Statistics;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.interfaces.TagBinaryRelationFiltering;
import utility.observers.ObserverBacktrackingUnsystematic;
import utility.observers.ObserverRuns;
import utility.observers.ObserverTwoPhases;
import variables.Variable;

public abstract class Solver {
    public List<ObserverRuns> observersRuns;
    public final List<ObserverTwoPhases> observersTwoPhases;
    public final Resolution rs;
    public final Problem pb;
    public final FutureVariables futVars;
    public final SolutionManager solManager;
    public final Restarter restarter;
    public Propagation propagation;
    public Enums.EStopping stoppingType;
    public Statistics stats;

    public final boolean isFullExploration() {
        return this.stoppingType == Enums.EStopping.FULL_EXPLORATION;
    }

    public final boolean hasFinished() {
        return this.stoppingType != null || this.rs.isTimeExpiredForCurrentInstance() && (this.stoppingType = Enums.EStopping.EXCEEDED_TIME) == Enums.EStopping.EXCEEDED_TIME;
    }

    public final void resetNoSolutions() {
        this.stoppingType = null;
        this.solManager.nSolutionsFound = 0L;
    }

    public void reset() {
        this.propagation.reset();
        Kit.control(!(this.propagation instanceof TagBinaryRelationFiltering), () -> "for the moment");
        Kit.control(this.futVars.nDiscarded() == 0);
        this.resetNoSolutions();
        this.restarter.reset();
    }

    public Solver(Resolution resolution) {
        this.rs = resolution;
        this.pb = resolution.problem;
        this.pb.solver = this;
        this.futVars = new FutureVariables(this.pb.variables);
        this.solManager = new SolutionManager(this, resolution.cp.general.nSearchedSolutions);
        this.propagation = resolution.cp.solving.enablePrepro || resolution.cp.solving.enableSearch ? Reflector.buildObject(resolution.cp.propagating.clazz, Propagation.class, this) : null;
        Kit.control(!resolution.cp.lns.enabled || !resolution.cp.lb.enabled, () -> "Cannot use LNS and LB (local branching) at the same time.");
        Restarter restarter = resolution.cp.lns.enabled ? new RestarterLNS(this) : (this.restarter = resolution.cp.lb.enabled ? new RestarterLB(this) : new Restarter(this));
        if (!resolution.cp.propagating.useAuxiliaryQueues) {
            Stream.of(this.pb.constraints).forEach(c -> {
                c.filteringComplexity = 0;
            });
        }
        this.observersTwoPhases = Stream.of(this.pb.constraints).filter(c -> c instanceof ObserverTwoPhases).map(c -> (ObserverTwoPhases)((Object)c)).collect(Collectors.toCollection(ArrayList::new));
    }

    public abstract int depth();

    public abstract void pushVariable(ObserverBacktrackingUnsystematic var1);

    public abstract void assign(Variable var1, int var2);

    public abstract void backtrack(Variable var1);

    public abstract void backtrack();

    private final void doPrepro() {
        this.stats.manageBeforePreprocessing();
        if (!this.propagation.runInitially()) {
            this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
        this.stats.manageAfterPreprocessing();
        this.rs.output.printAfterPreprocessing();
        if (this.stoppingType != Enums.EStopping.FULL_EXPLORATION) {
            this.observersTwoPhases.stream().forEach(observer -> observer.switchToSecondPhase());
        }
        this.pb.saveIntoXCSP(Enums.EExportMoment.PREPROCESSING);
    }

    public abstract Solver doRun();

    protected void doSearch() {
        while (!this.hasFinished() && !this.restarter.areAllRunsFinished()) {
            for (ObserverRuns observer : this.observersRuns) {
                observer.beforeRun();
            }
            if (this.stoppingType != Enums.EStopping.FULL_EXPLORATION) {
                this.doRun();
            }
            for (ObserverRuns observer : this.observersRuns) {
                observer.afterRun();
            }
            this.rs.output.printAfterSearch();
        }
    }

    public void solve() {
        if (Variable.firstWipeoutVariableIn(this.pb.variables) != null) {
            this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        } else {
            this.stats.manageBeforeSolve();
            if (this.rs.cp.solving.enablePrepro) {
                this.doPrepro();
            }
            if (this.rs.cp.solving.enableSearch && !this.hasFinished()) {
                this.doSearch();
            }
            this.stats.manageAfterRun();
        }
        this.rs.output.printFinal();
    }

    public void setDomainsMarks() {
        for (Variable x : this.pb.variables) {
            x.dom.setMark();
        }
    }

    public void restoreDomainsAtMarks() {
        for (Variable x : this.pb.variables) {
            x.dom.restoreAtMark();
        }
    }
}

