/*
 * Decompiled with CFR 0.152.
 */
package search;

import constraints.Constraint;
import constraints.CtrHard;
import executables.Resolution;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import propagation.order1.inverse.GIC1;
import search.Solver;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import search.backtrack.localBranching.RestarterLB;
import search.local.SolutionOptimizer;
import search.local.SolverLocal;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public final class SolutionManager {
    private final Resolution resolution;
    public final Solver solver;
    public long nSolutionsLimit;
    public long nSolutionsFound;
    public long bestBound;
    public int[] lastSolution;
    public String lastSolutionX;
    public final List<int[]> allSolutions;
    public int[] tmpHelene;
    private SolutionOptimizer solutionOptimizer;

    public SolutionManager(Solver solver, long nbSolutionsLimit) {
        this.resolution = solver.rs;
        this.solver = solver;
        this.nSolutionsLimit = nbSolutionsLimit;
        this.bestBound = this.resolution.cp.optimizing.upperBound;
        this.allSolutions = this.resolution.cp.general.recordSolutions ? new ArrayList() : null;
        this.solutionOptimizer = new SolutionOptimizer(this);
    }

    public void storeSolution(int[] t) {
        assert (t == null || t.length == this.resolution.problem.variables.length);
        this.lastSolution = this.lastSolution == null ? new int[this.resolution.problem.variables.length] : this.lastSolution;
        for (int i = 0; i < this.lastSolution.length; ++i) {
            this.lastSolution[i] = t != null ? t[i] : this.resolution.problem.variables[i].dom.unique();
        }
        this.resolution.observerRemote.onSolutionFound();
    }

    public void handleNewSolution(boolean controlSolution) {
        ++this.nSolutionsFound;
        if (this.nSolutionsFound >= this.nSolutionsLimit) {
            this.solver.stoppingType = Enums.EStopping.REACHED_GOAL;
        }
        this.storeSolution(null);
        this.solver.stats.manageSolution();
        if (this.allSolutions != null) {
            this.allSolutions.add((int[])this.lastSolution.clone());
        }
        Kit.control(!controlSolution || this.controlLastSolution());
        if (this.solver.propagation.performingProperSearch) {
            return;
        }
        if (this.resolution.problem.framework == Types.TypeFramework.MAXCSP) {
            int z = (int)Stream.of(this.resolution.problem.constraints).filter(c -> !((CtrHard)c).checkCurrentInstantiation()).count();
            Kit.control((long)z < this.bestBound, () -> "z=" + z + " bb=" + this.bestBound);
            this.bestBound = z;
            this.solver.restarter.optimizationStop = true;
        } else if (this.resolution.problem.optimizationPilot != null) {
            this.bestBound = this.resolution.problem.optimizationPilot.value();
            Kit.control(this.resolution.problem.optimizationPilot.isBetterBound(this.bestBound));
            this.solver.restarter.optimizationStop = true;
            if (this.resolution.cp.competitionMode) {
                System.out.println("o " + this.bestBound);
            }
        }
        this.resolution.problem.prettyDisplay();
        if (this.nSolutionsFound % 100000L == 0L) {
            Kit.log.fine("    " + this.nSolutionsFound + " solutions found  mem=" + Kit.getFormattedUsedMemorySize());
        }
        if (this.resolution.cp.lb.enabled) {
            ((RestarterLB)this.solver.restarter).enterLocalBranching();
        }
        if (this.resolution.cp.experimental.helene && this.solver instanceof SolverBacktrack) {
            DecisionRecorder dr = ((SolverBacktrack)this.solver).dr;
            Kit.log.info("NbNegativeDecisions=" + dr.decisions.sizeSuchThat(dec -> dec < 0) + " NBInverseTests=" + Kit.sum(((GIC1)this.solver.propagation).nInverseTests));
            this.tmpHelene = new int[this.solver.pb.variables.length + 1];
            for (Variable x : this.solver.pb.variables) {
                int a = x.dom.lastRemoved();
                while (a != -1) {
                    int l = x.dom.getRemovedLevelOf(a);
                    if (l != x.assignmentLevel()) {
                        int n = l;
                        this.tmpHelene[n] = this.tmpHelene[n] + 1;
                    }
                    a = x.dom.prevRemoved(a);
                }
            }
            Kit.log.info("NbRemovedValues=" + Kit.join((Object)this.tmpHelene, new String[0]));
        }
    }

    public void handleNewSolutionAndPossiblyOptimizeIt() {
        this.handleNewSolution(true);
        this.solutionOptimizer.optimizeCurrentSolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFinalResults() {
        if (this.resolution.cp.competitionMode) {
            AtomicBoolean atomicBoolean = this.resolution.competitionLock;
            synchronized (atomicBoolean) {
                if (!this.resolution.competitionLock.get()) {
                    this.resolution.competitionLock.set(true);
                    System.out.println();
                    if (this.lastSolutionX != null) {
                        System.out.println("v " + this.lastSolutionX);
                    }
                    if (this.nSolutionsFound == 0L) {
                        System.out.println(this.solver.isFullExploration() ? "s UNSATISFIABLE" : "s UNKNOWN");
                    } else {
                        System.out.println(this.resolution.problem.framework == Types.TypeFramework.CSP ? "s SATISFIABLE" : (this.solver.isFullExploration() ? "s OPTIMUM FOUND" : "s SATISFIABLE"));
                    }
                    System.out.println("\nd WRONG_DECISIONS " + this.resolution.solver.stats.nWrongDecisions);
                    if (this.resolution.solver.solManager.nSolutionsFound > 1L) {
                        System.out.println("d NUMBER_SOLUTIONS " + this.resolution.solver.solManager.nSolutionsFound);
                    }
                    System.out.flush();
                }
            }
        } else {
            Kit.log.config("\n<wrong> " + this.resolution.solver.stats.nWrongDecisions + " </wrong>");
            if (this.nSolutionsFound == 0L) {
                Kit.log.config(this.solver.isFullExploration() ? "<unsatisfiable/>" : "<unknown/>");
            } else {
                Kit.log.config(this.resolution.problem.framework == Types.TypeFramework.CSP ? "<satisfiable/>" : (this.solver.isFullExploration() ? "<optimum> " + this.bestBound + " </optimum>" : "<bound> " + this.bestBound + " </bound>"));
                if (this.resolution.problem.framework == Types.TypeFramework.CSP) {
                    Kit.log.config("<nbSolutions> " + (this.solver.isFullExploration() ? "" : "at least ") + this.nSolutionsFound + " </nbSolutions>");
                }
            }
            System.out.flush();
        }
    }

    public boolean control(int[] solution) {
        for (Constraint ctr : this.resolution.problem.constraints) {
            if (ctr.ignored) continue;
            int[] tmp = ctr.tupleManager.localTuple;
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = solution[ctr.scp[i].num];
            }
            if (((CtrHard)ctr).checkIndexes(tmp)) continue;
            return false;
        }
        return true;
    }

    private boolean controlLastSolution() {
        if (!(this.solver instanceof SolverLocal)) {
            Stream.of(this.resolution.problem.variables).forEach(x -> Kit.control(x.dom.size() == 1, () -> "Problem with last solution: variable " + x + " has not a unique value"));
        }
        if (this.solver instanceof SolverBacktrack && (this.resolution.problem.framework == Types.TypeFramework.MAXCSP || this.resolution.problem.framework == Types.TypeFramework.WCSP)) {
            return true;
        }
        Stream.of(this.resolution.problem.constraints).forEach(c -> Kit.control(c.ignored || !(c instanceof CtrHard) || ((CtrHard)c).seekFirstSupport(), () -> "Problem with last solution: constraint " + c + " not satisfied : "));
        return true;
    }
}

