/*
 * Decompiled with CFR 0.152.
 */
package search;

import java.util.function.Supplier;
import org.xcsp.common.Types;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.observers.ObserverRuns;

public class Restarter
implements ObserverRuns {
    public Solver solver;
    public int numRun = -1;
    public boolean optimizationStop;
    public long baseCutoff;
    public long currCutoff;
    private int nRestartsSinceLastReset = -1;
    public final Supplier<Long> measureSupplier;
    private long cnt;
    private boolean lubyStrategy = false;
    private long nbAssignmentsWhenLastImprovement = 0L;

    @Override
    public void beforeRun() {
        ++this.numRun;
        ++this.nRestartsSinceLastReset;
        if (this.nRestartsSinceLastReset == this.solver.rs.cp.restarting.nRestartsResetPeriod) {
            this.nRestartsSinceLastReset = 0;
            this.baseCutoff *= (long)this.solver.rs.cp.restarting.nRestartsResetCoefficient;
            Kit.log.info("BaseCutoff reset to " + this.baseCutoff);
        }
        if (this.currCutoff != Long.MAX_VALUE) {
            this.currCutoff = this.measureSupplier.get();
            this.currCutoff += this.lubyStrategy ? this.lubyCutoffFor(this.numRun + 1) * 100L : (long)((double)this.baseCutoff * Math.pow(this.solver.rs.cp.restarting.factor, this.nRestartsSinceLastReset));
        }
        if (this.optimizationStop) {
            this.optimizationStop = false;
            this.nRestartsSinceLastReset = 0;
            if (!this.solver.propagation.runInitially()) {
                this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
            }
        }
    }

    @Override
    public void afterRun() {
        if (this.solver.rs.cp.framework == Types.TypeFramework.COP) {
            this.solver.pb.optimizationPilot.afterRun();
        }
    }

    public void reset() {
        this.numRun = -1;
        this.currCutoff = this.baseCutoff = this.solver.rs.cp.restarting.cutoff;
        this.nRestartsSinceLastReset = -1;
    }

    private Supplier<Long> measureSupplier(Enums.ERestartsMeasure restartsMeasure) {
        SolverBacktrack sb = this.solver instanceof SolverBacktrack ? (SolverBacktrack)this.solver : null;
        switch (restartsMeasure) {
            case FAILED: {
                return () -> sb.backtrackStatistics.nFailedAssignments;
            }
            case WRONG: {
                return () -> sb.backtrackStatistics.nWrongDecisions;
            }
            case BACKTRACK: {
                return () -> sb.backtrackStatistics.nBacktracks;
            }
            case MAX_DEPTH: {
                return () -> ((SolverBacktrack)this.solver).maxDepth;
            }
            case SOLUTION: {
                return () -> this.solver.solManager.nSolutionsFound;
            }
        }
        throw new UnreachableCodeException();
    }

    public Restarter(Solver solver) {
        this.solver = solver;
        this.measureSupplier = this.measureSupplier(solver.rs.cp.restarting.measure);
        this.reset();
    }

    public boolean hasFinishedRun() {
        if (this.solver.pb.optimizationPilot != null && this.cnt++ % 5L == 0L) {
            this.solver.pb.optimizationPilot.possiblyUpdateLocalBounds();
        }
        return this.measureSupplier.get() >= this.currCutoff || this.optimizationStop;
    }

    public boolean areAllRunsFinished() {
        return this.numRun + 1 >= this.solver.rs.cp.restarting.n;
    }

    private long lubyCutoffFor(long i) {
        int k = (int)Math.floor(Math.log(i) / Math.log(2.0)) + 1;
        long pow = (long)Math.pow(2.0, k - 1);
        return i == pow * 2L - 1L ? pow : this.lubyCutoffFor(i - pow + 1L);
    }

    public void newMaxCSPSolutionFound() {
        if (this.currCutoff != Long.MAX_VALUE) {
            this.currCutoff += Math.min(1000L, this.solver.stats.nAssignments - this.nbAssignmentsWhenLastImprovement);
            this.nbAssignmentsWhenLastImprovement = this.solver.stats.nAssignments;
        }
    }
}

