/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.supporters;

import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtension;
import java.util.stream.Stream;
import propagation.structures.supporters.SupporterSoft;
import utility.Kit;
import variables.Variable;

public final class SupporterSoftBary
extends SupporterSoft {
    private final int[][] residues;
    private int[][] fdacResidues;

    public SupporterSoftBary(CtrSoft c) {
        super(c);
        Kit.control(c.scp.length == 2);
        this.residues = Variable.litterals(c.scp).intArray(-1);
    }

    @Override
    public long findMinCostFor(int p, int a) {
        int q = p == 0 ? 1 : 0;
        int b = this.residues[p][a];
        if (b != -1 && ((CtrSoft)this.c).doms[q].isPresent(b)) {
            this.buffer[p] = a;
            this.buffer[q] = b;
            if (((CtrSoft)this.c).costOfIdxs(this.buffer) == 0L) {
                return 0L;
            }
        }
        int[] t = ((CtrSoft)this.c).getMinCostTupleFor(p, a);
        this.residues[p][a] = b = t[q];
        if (this.multidirectionality) {
            this.residues[q][b] = a;
        }
        return ((CtrSoft)this.c).costOfIdxs(t);
    }

    @Override
    public long findMinFullCostFor(int p, int a, int sourcePosition) {
        if (this.fdacResidues == null) {
            this.fdacResidues = (int[][])Stream.of(((CtrSoft)this.c).scp).map(x -> Kit.repeat(-1, x.dom.initSize())).toArray(x$0 -> new int[x$0][]);
        }
        Kit.control(sourcePosition == (p == 0 ? 1 : 0));
        long[] c1 = ((CtrSoftExtension)this.c).getC1For(sourcePosition);
        int fdacResidue = this.fdacResidues[p][a];
        if (fdacResidue != -1 && c1[fdacResidue] == 0L && ((CtrSoft)this.c).doms[sourcePosition].isPresent(fdacResidue)) {
            this.buffer[p] = a;
            this.buffer[sourcePosition] = fdacResidue;
            if (((CtrSoft)this.c).costOfIdxs(this.buffer) == 0L) {
                return 0L;
            }
        }
        int[] t = ((CtrSoft)this.c).getMinFullCostTupleFor(p, a, sourcePosition);
        this.fdacResidues[p][a] = t[sourcePosition];
        return ((CtrSoft)this.c).costOfIdxs(t) + c1[t[sourcePosition]];
    }
}

