/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.supporters;

import constraints.CtrHard;
import java.util.stream.Stream;
import propagation.structures.supporters.SupporterHard;
import utility.Kit;

public final class SupporterHardNary
extends SupporterHard {
    private final int[][][] residues;

    @Override
    public void reset() {
        Stream.of(this.residues).forEach(m -> Kit.fill(m, -1));
    }

    public SupporterHardNary(CtrHard c) {
        super(c);
        Kit.control(c.scp.length > 2);
        this.residues = (int[][][])Stream.of(c.scp).map(x -> Kit.repeat(-1, x.dom.initSize(), c.scp.length)).toArray(x$0 -> new int[x$0][][]);
    }

    @Override
    public boolean findArcSupportFor(int x, int a) {
        int[] residue = this.residues[x][a];
        int q = x == 0 ? 1 : 0;
        if (residue[q] != -1 && ((CtrHard)this.c).isValid(residue)) {
            return true;
        }
        if (((CtrHard)this.c).seekFirstSupportWith(x, a, this.buffer)) {
            if (this.multidirectionality) {
                for (int i = 0; i < this.residues.length; ++i) {
                    Kit.copy(this.buffer, this.residues[i][this.buffer[i]]);
                }
            } else {
                Kit.copy(this.buffer, this.residues[x][a]);
            }
            return true;
        }
        return false;
    }
}

