/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import propagation.soft.sac.AdvancedSoftAC;
import search.Solver;
import utility.interfaces.FilteringSpecific;
import utility.sets.SetSparse;
import variables.Variable;

public final class EDAC
extends AdvancedSoftAC {
    private SetSparse queueR;
    private SetSparse queueS;
    private SetSparse queueP;

    public EDAC(Solver solver) {
        super(solver);
        this.queueR = new SetSparse(solver.pb.variables.length);
        this.queueS = new SetSparse(solver.pb.variables.length);
        this.queueP = new SetSparse(solver.pb.variables.length);
    }

    @Override
    protected void handleIncreasedUnaryCostFromBottomFor(Variable x) {
        this.queueR.add(x.num);
    }

    private void addHigherNeighborsOf(Variable x, SetSparse queue) {
        for (Constraint c : x.ctrs) {
            if (c.scp.length <= 1 || c instanceof FilteringSpecific || this.constraintsMembership[c.num] != x) continue;
            for (Variable y : c.scp) {
                if (y == x) continue;
                queue.add(y.num);
            }
        }
    }

    private boolean edac() {
        Variable[] variables = this.solver.pb.variables;
        while (this.queue.size() != 0 || this.queueR.size() != 0 || this.queueS.size() != 0) {
            this.queueP.clear();
            for (int i = this.queueS.limit; i >= 0; --i) {
                Variable x = variables[this.queueS.dense[i]];
                this.queueP.add(x.num);
                this.addHigherNeighborsOf(x, this.queueP);
            }
            this.queueS.clear();
            while (this.queueP.size() != 0) {
                Variable x = this.pickAndDeleteVariableIn(this.queueP, false);
                if (!this.findExistentialSupport(x)) continue;
                this.queueR.add(x.num);
                this.addHigherNeighborsOf(x, this.queueP);
            }
            while (this.queueR.size() != 0) {
                Variable x = this.pickAndDeleteVariableIn(this.queueR, true);
                for (Constraint c : x.ctrs) {
                    Variable lowestVar;
                    if (c.scp.length <= 1 || c instanceof FilteringSpecific || (lowestVar = this.constraintsMembership[c.num]) == x || !this.findFullSupports(c, x, lowestVar)) continue;
                    this.queueR.add(lowestVar.num);
                    this.queueS.add(lowestVar.num);
                }
            }
            while (this.queue.size() != 0) {
                Variable x = this.pickAndDeleteVariableIn(this.queue, false);
                for (Constraint c : x.ctrs) {
                    if (c instanceof FilteringSpecific || c.scp.length == 1 && x.ctrs.length > 1) continue;
                    for (int i = c.futvars.limit; i >= 0; --i) {
                        Variable y = c.scp[c.futvars.dense[i]];
                        if (!this.findSupports(c, y)) continue;
                        this.queueR.add(y.num);
                        this.queueS.add(y.num);
                    }
                }
            }
            if (this.pruneVars()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean runInitially() {
        if (!super.runInitially()) {
            return false;
        }
        this.queueR.fill();
        this.queueS.fill();
        this.queue.fill();
        if (!this.edac()) {
            return false;
        }
        assert (this.queue.isEmpty()) : this.queue.size();
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent() && this.isEACConsistent());
        return true;
    }

    @Override
    protected boolean updateQueuesWhenDecreasedUpperBound() {
        if (!super.updateQueuesWhenDecreasedUpperBound()) {
            return false;
        }
        this.solver.futVars.execute(x -> {
            this.queueR.add(x.num);
            this.queueS.add(x.num);
        });
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        if (!super.runAfterAssignment(x)) {
            return false;
        }
        this.queueR.add(x.num);
        this.queueS.add(x.num);
        if (!this.edac()) {
            return false;
        }
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent() && this.isEACConsistent());
        return true;
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        if (!super.runAfterRefutation(x)) {
            return false;
        }
        this.queueR.add(x.num);
        this.queueS.add(x.num);
        if (!this.edac()) {
            return false;
        }
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent() && this.isEACConsistent());
        return true;
    }
}

