/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtension;
import java.util.stream.Stream;
import propagation.soft.sac.SoftAC;
import propagation.structures.supporters.SupporterSoft;
import search.Solver;
import utility.Kit;
import utility.interfaces.FilteringSpecific;
import utility.operations.Calculator;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public abstract class AdvancedSoftAC
extends SoftAC {
    protected int[] variablesRank;
    protected Variable[] constraintsMembership;
    protected long[] projectionCosts;
    protected long[] extensionCosts;

    public AdvancedSoftAC(Solver solver) {
        super(solver);
        Variable[] sortedVariables = Kit.sort((Object[])solver.pb.variables.clone(), Variable.decreasingStaticDegComparator);
        this.variablesRank = new int[sortedVariables.length];
        for (int i = 0; i < this.variablesRank.length; ++i) {
            this.variablesRank[sortedVariables[i].num] = i;
        }
        Constraint[] ctrs = solver.pb.constraints;
        this.constraintsMembership = new Variable[ctrs.length];
        for (int i = 0; i < this.constraintsMembership.length; ++i) {
            Variable[] scope = ctrs[i].scp;
            int lowestVariablePosition = 0;
            int lowestRank = this.variablesRank[scope[0].num];
            for (int j = 1; j < scope.length; ++j) {
                int rank = this.variablesRank[scope[j].num];
                if (rank >= lowestRank) continue;
                lowestVariablePosition = j;
                lowestRank = rank;
            }
            this.constraintsMembership[i] = scope[lowestVariablePosition];
        }
        this.projectionCosts = new long[Variable.maxInitDomSize(solver.pb.variables)];
        this.extensionCosts = new long[this.projectionCosts.length];
    }

    protected Variable pickAndDeleteVariableIn(SetSparse queue, boolean highest) {
        int[] dense = queue.dense;
        int bestId = dense[queue.limit];
        for (int i = queue.limit - 1; i >= 0; --i) {
            if (this.variablesRank[dense[i]] > this.variablesRank[bestId] != highest) continue;
            bestId = dense[i];
        }
        queue.remove(bestId);
        return this.solver.pb.variables[bestId];
    }

    protected boolean findFullSupports(Constraint ctr, Variable sourceVariable, Variable targetVariable) {
        if (!ctr.canBeCurrentlyGenericallyFiltered()) {
            return false;
        }
        boolean flag = false;
        int sourcePosition = ctr.positionOf(sourceVariable);
        Domain sourceDomain = sourceVariable.dom;
        long[] c1 = this.c1s[targetVariable.num];
        int targetPosition = ctr.positionOf(targetVariable);
        assert (sourcePosition != targetPosition);
        boolean identifiedProjection = false;
        Domain targetDomain = targetVariable.dom;
        int targetIdx = targetDomain.first();
        while (targetIdx != -1) {
            this.projectionCosts[targetIdx] = ((SupporterSoft)ctr.supporter()).findMinFullCostFor(targetPosition, targetIdx, sourcePosition);
            if (this.projectionCosts[targetIdx] > 0L) {
                identifiedProjection = true;
                if (c1[targetIdx] == 0L) {
                    flag = true;
                }
            }
            if (this.cp().verbose > 1 && this.projectionCosts[targetIdx] > 0L) {
                Kit.log.finer(targetVariable + " " + targetIdx + " prj=" + this.projectionCosts[targetIdx]);
            }
            targetIdx = targetDomain.next(targetIdx);
        }
        if (!identifiedProjection) {
            return flag;
        }
        int sourceIdx = sourceDomain.first();
        while (sourceIdx != -1) {
            int[] t = ((CtrSoftExtension)ctr).getMaxExtensionCostTuple(targetPosition, this.projectionCosts, sourcePosition, sourceIdx);
            this.extensionCosts[sourceIdx] = Calculator.add(this.projectionCosts[t[targetPosition]], -ctr.costOfIdxs(t));
            if (this.cp().verbose > 1 && this.extensionCosts[sourceIdx] > 0L) {
                Kit.log.finer(sourceVariable + " " + sourceIdx + " ext=" + this.extensionCosts[sourceIdx] + " c1=" + this.c1s[sourceVariable.num][sourceIdx]);
            }
            sourceIdx = sourceDomain.next(sourceIdx);
        }
        sourceIdx = sourceDomain.first();
        while (sourceIdx != -1) {
            if (this.extensionCosts[sourceIdx] > 0L) {
                ((CtrSoftExtension)ctr).extStructure().projectAndStack(sourcePosition, sourceIdx, -this.extensionCosts[sourceIdx]);
            }
            sourceIdx = sourceDomain.next(sourceIdx);
        }
        long minUnaryCost = Long.MAX_VALUE;
        int targetIdx2 = targetDomain.first();
        while (targetIdx2 != -1) {
            if (this.projectionCosts[targetIdx2] > 0L) {
                ((CtrSoftExtension)ctr).extStructure().projectAndStack(targetPosition, targetIdx2, this.projectionCosts[targetIdx2]);
            }
            minUnaryCost = Math.min(c1[targetIdx2], minUnaryCost);
            targetIdx2 = targetDomain.next(targetIdx2);
        }
        if (minUnaryCost > 0L) {
            this.unaryProjectAndStack(targetVariable, minUnaryCost);
        }
        if (ctr.scp.length > 2) {
            if (!sourceVariable.isAssigned()) {
                this.queue.add(sourceVariable);
            }
            if (!targetVariable.isAssigned()) {
                this.queue.add(targetVariable);
            }
        }
        assert (((CtrSoft)ctr).controlCosts()) : ctr;
        return flag;
    }

    protected boolean findExistentialSupport(Variable var) {
        long[] c1 = this.c1s[var.num];
        Domain dom = var.dom;
        int idx = dom.first();
        while (idx != -1) {
            if (c1[idx] <= 0L) {
                boolean existentiallySupported = true;
                Constraint[] constraintArray = var.ctrs;
                int n = constraintArray.length;
                for (int i = 0; i < n; ++i) {
                    Constraint ctr = constraintArray[i];
                    Variable lowestVariable = this.constraintsMembership[ctr.num];
                    if (ctr.scp.length <= 1 || ctr instanceof FilteringSpecific || lowestVariable == var || !ctr.canBeCurrentlyGenericallyFiltered() || ((SupporterSoft)ctr.supporter()).findMinFullCostFor(var, idx, ctr.positionOf(lowestVariable)) <= 0L) continue;
                    existentiallySupported = false;
                    break;
                }
                if (existentiallySupported) {
                    return false;
                }
            }
            idx = dom.next(idx);
        }
        boolean flag = false;
        for (Constraint ctr : var.ctrs) {
            if (ctr.scp.length <= 1 || ctr instanceof FilteringSpecific || this.constraintsMembership[ctr.num] == var || !ctr.canBeCurrentlyGenericallyFiltered() || !this.findFullSupports(ctr, this.constraintsMembership[ctr.num], var)) continue;
            flag = true;
        }
        return flag;
    }

    protected boolean isDACConsistent(Constraint ctr, Variable sourceVariable, Variable targetVariable) {
        int sourcePosition = ctr.positionOf(sourceVariable);
        long[] c1 = ((CtrSoftExtension)ctr).getC1For(sourcePosition);
        int targetPosition = ctr.positionOf(targetVariable);
        Domain targetDomain = targetVariable.dom;
        int targetIdx = targetDomain.first();
        while (targetIdx != -1) {
            int[] t = ((CtrSoft)ctr).getMinFullCostTupleFor(targetPosition, targetIdx, sourcePosition);
            if (Calculator.add(ctr.costOfIdxs(t), c1[t[sourcePosition]]) != 0L) {
                Kit.log.finer("source " + Kit.join((Object)c1, new String[0]));
                sourceVariable.display(true);
                Kit.log.finer("target " + Kit.join((Object)((CtrSoftExtension)ctr).getC1For(targetPosition), new String[0]));
                targetVariable.display(true);
                Kit.log.finer(((CtrSoftExtension)ctr).extStructure().toString());
                Kit.log.finer("DAC inconsistent " + targetVariable + " " + ctr + " " + targetIdx + " source=" + sourcePosition + " " + targetVariable.isAssigned() + " " + c1[t[sourcePosition]]);
                return false;
            }
            targetIdx = targetDomain.next(targetIdx);
        }
        return true;
    }

    protected boolean isDACConsistent() {
        for (Variable targetVariable : this.solver.pb.variables) {
            for (Constraint ctr : targetVariable.ctrs) {
                if (ctr.scp.length == 1 || ctr instanceof FilteringSpecific || this.constraintsMembership[ctr.num] != targetVariable || !ctr.canBeCurrentlyGenericallyFiltered() || ctr.scp.length > 2) continue;
                Variable[] scope = ctr.scp;
                for (int i = 0; i < scope.length; ++i) {
                    if (scope[i] == targetVariable || this.isDACConsistent(ctr, scope[i], targetVariable)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isEACConsistent(Variable var) {
        long[] c1 = this.c1s[var.num];
        Domain dom = var.dom;
        int idx = dom.first();
        while (idx != -1) {
            if (c1[idx] <= 0L) {
                boolean existentiallySupported = true;
                for (Constraint ctr : var.ctrs) {
                    int[] t;
                    if (ctr.scp.length >= 3) continue;
                    Variable lowestVariable = this.constraintsMembership[ctr.num];
                    if (ctr.scp.length <= 1 || ctr instanceof FilteringSpecific || lowestVariable == var || !ctr.canBeCurrentlyGenericallyFiltered() || Calculator.add(ctr.costOfIdxs(t = ((CtrSoft)ctr).getMinFullCostTupleFor(ctr.positionOf(var), idx, ctr.positionOf(lowestVariable))), this.c1s[lowestVariable.num][t[ctr.positionOf(lowestVariable)]]) <= 0L) continue;
                    existentiallySupported = false;
                    break;
                }
                if (existentiallySupported) {
                    return true;
                }
            }
            idx = dom.next(idx);
        }
        return false;
    }

    protected boolean isEACConsistent() {
        Stream.of(this.solver.pb.variables).forEach(x -> Kit.control(this.isEACConsistent((Variable)x), () -> "EAC inconsistent " + x));
        return true;
    }
}

