/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.path;

import constraints.CtrHard;
import java.util.stream.IntStream;
import problem.cliques.CliqueManager;
import propagation.order2.SecondOrderConsistency;
import propagation.order2.path.PropagationSetOfValues;
import search.Solver;
import utility.Kit;
import variables.Variable;

public class PC8
extends SecondOrderConsistency {
    protected CtrHard[][] constraintsAccess;
    protected PropagationSetOfValues queue;
    protected int[] nSupports;

    public PC8(Solver solver) {
        super(solver);
        this.constraintsAccess = (CtrHard[][])IntStream.range(0, this.hards.length).mapToObj(CtrHard[]::new).toArray(x$0 -> new CtrHard[x$0][]);
        int cnt = 0;
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2) continue;
            ++cnt;
            int num1 = c.scp[0].num;
            int num2 = c.scp[1].num;
            if (num1 > num2) {
                this.constraintsAccess[num1][num2] = c;
                continue;
            }
            this.constraintsAccess[num2][num1] = c;
        }
        Kit.control(cnt == solver.pb.variables.length * (solver.pb.variables.length - 1) / 2, () -> "The graph is not complete: use the option -cg=yes. ");
        this.queue = new PropagationSetOfValues(solver.pb);
        this.nSupports = new int[solver.pb.constraints.length];
    }

    protected boolean checkPathConsistencyOfSupport(CtrHard c, int[] support, Variable z) {
        CtrHard cyz;
        Variable x = c.scp[0];
        Variable y = c.scp[1];
        int a = support[0];
        int b = support[1];
        CtrHard cxz = z.num > x.num ? this.constraintsAccess[z.num][x.num] : this.constraintsAccess[x.num][z.num];
        CtrHard ctrHard = cyz = z.num > y.num ? this.constraintsAccess[z.num][y.num] : this.constraintsAccess[y.num][z.num];
        if (CliqueManager.getPathSupport(x, y, a, b, z, -1, cxz, cyz) == -1) {
            c.removeTuple(support);
            this.queue.add(c, x, a).add(c, y, b);
            return false;
        }
        return true;
    }

    private boolean filterConstraint(CtrHard c) {
        int cnt = 0;
        int[] tuple = c.tupleManager.localTuple;
        boolean foundSupport = c.seekFirstSupport();
        while (foundSupport) {
            boolean consistent = true;
            for (Variable x : this.solver.pb.variables) {
                if (x == c.scp[0] || x == c.scp[1] || this.checkPathConsistencyOfSupport(c, tuple, x)) continue;
                consistent = false;
                break;
            }
            if (consistent) {
                ++cnt;
            }
            foundSupport = c.seekNextSupport();
        }
        if (cnt == 0) {
            return false;
        }
        this.nSupports[c.num] = cnt;
        return true;
    }

    protected boolean initialize() {
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2 || this.filterConstraint(c)) continue;
            return false;
        }
        return true;
    }

    private boolean revisePath(CtrHard c, Variable x, int a) {
        Variable z = c.scp[c.scp[0] == x ? 1 : 0];
        for (Variable y : this.solver.pb.variables) {
            if (y == c.scp[0] || y == c.scp[1]) continue;
            CtrHard cxy = y.num > x.num ? this.constraintsAccess[y.num][x.num] : this.constraintsAccess[x.num][y.num];
            int p = cxy.positionOf(x);
            int[] tuple = cxy.tupleManager.localTuple;
            boolean foundSupport = cxy.seekFirstSupportWith(p, a);
            while (foundSupport) {
                if (!this.checkPathConsistencyOfSupport(cxy, tuple, z)) {
                    int n = cxy.num;
                    this.nSupports[n] = this.nSupports[n] - 1;
                }
                foundSupport = cxy.seekNextSupport();
            }
            if (this.nSupports[cxy.num] != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean enforceSecondOrderConsistency() {
        if (!this.initialize()) {
            return false;
        }
        while (this.queue.size() > 0) {
            CtrHard c = this.queue.firstConstraint();
            Variable x = this.queue.firstVariable();
            int a = this.queue.firstIndex();
            this.queue.remove(0);
            if (this.revisePath(c, x, a)) continue;
            return false;
        }
        if (!this.enforceArcConsistency()) {
            return false;
        }
        Kit.log.info("after revise PC, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
        return true;
    }
}

