/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.path;

import constraints.CtrHard;
import problem.cliques.Clique;
import problem.cliques.CliqueManager;
import propagation.order2.SecondOrderConsistency;
import propagation.order2.path.PropagationSetOfValues;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class CPC8
extends SecondOrderConsistency {
    protected CliqueManager cliqueManager;
    protected PropagationSetOfValues queue;
    protected int[] nSupports;
    protected boolean strongCPC = true;

    public CPC8(Solver solver) {
        super(solver);
        this.cliqueManager = new CliqueManager(solver.pb);
        this.queue = new PropagationSetOfValues(solver.pb);
        this.nSupports = new int[solver.pb.constraints.length];
    }

    protected boolean checkPathConsistencyOfSupport(CtrHard c, int[] tuple, Clique clique) {
        if (this.cliqueManager.getPathSupport(c, tuple, clique, -1) == -1) {
            c.removeTuple(tuple);
            this.queue.add(c, c.scp[0], tuple[0]).add(c, c.scp[1], tuple[1]);
            return false;
        }
        return true;
    }

    private boolean isCurrTupleConsistentForCliques(CtrHard c) {
        int[] tuple = c.tupleManager.currTuple();
        for (Clique clique : this.cliqueManager.cliques[c.num]) {
            if (this.checkPathConsistencyOfSupport(c, tuple, clique)) continue;
            return false;
        }
        return true;
    }

    private boolean filterConstraint(CtrHard c) {
        int cnt = 0;
        boolean foundSupport = c.seekFirstSupport();
        while (foundSupport) {
            if (this.isCurrTupleConsistentForCliques(c)) {
                ++cnt;
            }
            foundSupport = c.seekNextSupport();
        }
        if (cnt == 0) {
            return false;
        }
        this.nSupports[c.num] = cnt;
        return true;
    }

    protected boolean initialize() {
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2 || this.cliqueManager.cliques[c.num].length <= 0 || this.filterConstraint(c)) continue;
            return false;
        }
        return true;
    }

    private boolean revisePath(CtrHard c, Variable x, int a) {
        for (Clique clique : this.cliqueManager.cliques[c.num]) {
            CtrHard cxy = (CtrHard)clique.getEdgeConstraint(c, x);
            int p = cxy.positionOf(x);
            int[] tuple = cxy.tupleManager.localTuple;
            boolean foundSupport = cxy.seekFirstSupportWith(p, a);
            while (foundSupport) {
                if (!this.checkPathConsistencyOfSupport(cxy, tuple, clique)) {
                    int n = cxy.num;
                    this.nSupports[n] = this.nSupports[n] - 1;
                }
                foundSupport = cxy.seekNextSupport();
            }
            if (this.nSupports[cxy.num] != 0) continue;
            return false;
        }
        return true;
    }

    private void removeArcConsistentValues() {
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2) continue;
            Domain[] doms = c.doms;
            for (int i = 0; i < doms.length; ++i) {
                int a = doms[i].first();
                while (a != -1) {
                    if (!c.seekFirstSupportWith(i, a)) {
                        doms[i].removeElementary(a);
                    }
                    a = doms[i].next(a);
                }
            }
        }
        Kit.log.info("after removeAC, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
    }

    @Override
    public boolean enforceSecondOrderConsistency() {
        if (!this.initialize()) {
            return false;
        }
        Kit.log.info("after init PC, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
        while (this.queue.size() > 0) {
            CtrHard c = this.queue.firstConstraint();
            Variable x = this.queue.firstVariable();
            int a = this.queue.firstIndex();
            this.queue.remove(0);
            if (this.revisePath(c, x, a)) continue;
            return false;
        }
        Kit.log.info("after revise PC, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
        if (this.strongCPC) {
            this.removeArcConsistentValues();
        }
        return true;
    }
}

